/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a finding category with open findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoryWithFindingNum implements SdkPojo, Serializable,
        ToCopyableBuilder<CategoryWithFindingNum.Builder, CategoryWithFindingNum> {
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("categoryName").getter(getter(CategoryWithFindingNum::categoryName))
            .setter(setter(Builder::categoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categoryName").build()).build();

    private static final SdkField<Integer> FINDING_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("findingNumber").getter(getter(CategoryWithFindingNum::findingNumber))
            .setter(setter(Builder::findingNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_NAME_FIELD,
            FINDING_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String categoryName;

    private final Integer findingNumber;

    private CategoryWithFindingNum(BuilderImpl builder) {
        this.categoryName = builder.categoryName;
        this.findingNumber = builder.findingNumber;
    }

    /**
     * <p>
     * The name of the finding category. A finding category is determined by the detector that detected the finding.
     * </p>
     * 
     * @return The name of the finding category. A finding category is determined by the detector that detected the
     *         finding.
     */
    public final String categoryName() {
        return categoryName;
    }

    /**
     * <p>
     * The number of open findings in the category.
     * </p>
     * 
     * @return The number of open findings in the category.
     */
    public final Integer findingNumber() {
        return findingNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryName());
        hashCode = 31 * hashCode + Objects.hashCode(findingNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryWithFindingNum)) {
            return false;
        }
        CategoryWithFindingNum other = (CategoryWithFindingNum) obj;
        return Objects.equals(categoryName(), other.categoryName()) && Objects.equals(findingNumber(), other.findingNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryWithFindingNum").add("CategoryName", categoryName())
                .add("FindingNumber", findingNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "categoryName":
            return Optional.ofNullable(clazz.cast(categoryName()));
        case "findingNumber":
            return Optional.ofNullable(clazz.cast(findingNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryWithFindingNum, T> g) {
        return obj -> g.apply((CategoryWithFindingNum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryWithFindingNum> {
        /**
         * <p>
         * The name of the finding category. A finding category is determined by the detector that detected the finding.
         * </p>
         * 
         * @param categoryName
         *        The name of the finding category. A finding category is determined by the detector that detected the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryName(String categoryName);

        /**
         * <p>
         * The number of open findings in the category.
         * </p>
         * 
         * @param findingNumber
         *        The number of open findings in the category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingNumber(Integer findingNumber);
    }

    static final class BuilderImpl implements Builder {
        private String categoryName;

        private Integer findingNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryWithFindingNum model) {
            categoryName(model.categoryName);
            findingNumber(model.findingNumber);
        }

        public final String getCategoryName() {
            return categoryName;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final Integer getFindingNumber() {
            return findingNumber;
        }

        public final void setFindingNumber(Integer findingNumber) {
            this.findingNumber = findingNumber;
        }

        @Override
        public final Builder findingNumber(Integer findingNumber) {
            this.findingNumber = findingNumber;
            return this;
        }

        @Override
        public CategoryWithFindingNum build() {
            return new CategoryWithFindingNum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
