/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScanRequest extends CodeGuruSecurityRequest implements
        ToCopyableBuilder<CreateScanRequest.Builder, CreateScanRequest> {
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analysisType").getter(getter(CreateScanRequest::analysisTypeAsString))
            .setter(setter(Builder::analysisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateScanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ResourceId> RESOURCE_ID_FIELD = SdkField.<ResourceId> builder(MarshallingType.SDK_POJO)
            .memberName("resourceId").getter(getter(CreateScanRequest::resourceId)).setter(setter(Builder::resourceId))
            .constructor(ResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(CreateScanRequest::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanType").getter(getter(CreateScanRequest::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateScanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_TYPE_FIELD,
            CLIENT_TOKEN_FIELD, RESOURCE_ID_FIELD, SCAN_NAME_FIELD, SCAN_TYPE_FIELD, TAGS_FIELD));

    private final String analysisType;

    private final String clientToken;

    private final ResourceId resourceId;

    private final String scanName;

    private final String scanType;

    private final Map<String, String> tags;

    private CreateScanRequest(BuilderImpl builder) {
        super(builder);
        this.analysisType = builder.analysisType;
        this.clientToken = builder.clientToken;
        this.resourceId = builder.resourceId;
        this.scanName = builder.scanName;
        this.scanType = builder.scanType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
     * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     * <code>All</code> type generates both security findings and quality findings. Defaults to <code>Security</code>
     * type if missing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
     *         <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     *         <code>All</code> type generates both security findings and quality findings. Defaults to
     *         <code>Security</code> type if missing.
     * @see AnalysisType
     */
    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(analysisType);
    }

    /**
     * <p>
     * The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
     * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     * <code>All</code> type generates both security findings and quality findings. Defaults to <code>Security</code>
     * type if missing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysisType} will
     * return {@link AnalysisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisTypeAsString}.
     * </p>
     * 
     * @return The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
     *         <code>All</code>. The <code>Security</code> type only generates findings related to security. The
     *         <code>All</code> type generates both security findings and quality findings. Defaults to
     *         <code>Security</code> type if missing.
     * @see AnalysisType
     */
    public final String analysisTypeAsString() {
        return analysisType;
    }

    /**
     * <p>
     * The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental
     * creation of duplicate scans if there are failures and retries.
     * </p>
     * 
     * @return The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental
     *         creation of duplicate scans if there are failures and retries.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier for an input resource used to create a scan.
     * </p>
     * 
     * @return The identifier for an input resource used to create a scan.
     */
    public final ResourceId resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The unique name that CodeGuru Security uses to track revisions across multiple scans of the same resource. Only
     * allowed for a <code>STANDARD</code> scan type. If not specified, it will be auto generated.
     * </p>
     * 
     * @return The unique name that CodeGuru Security uses to track revisions across multiple scans of the same
     *         resource. Only allowed for a <code>STANDARD</code> scan type. If not specified, it will be auto
     *         generated.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code> type if
     * missing.
     * </p>
     * <p>
     * <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your code in
     * near-real time. <code>Standard</code> scans have standard resource limits and use the full set of detectors to
     * analyze your code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code>
     *         type if missing.</p>
     *         <p>
     *         <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your
     *         code in near-real time. <code>Standard</code> scans have standard resource limits and use the full set of
     *         detectors to analyze your code.
     * @see ScanType
     */
    public final ScanType scanType() {
        return ScanType.fromValue(scanType);
    }

    /**
     * <p>
     * The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code> type if
     * missing.
     * </p>
     * <p>
     * <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your code in
     * near-real time. <code>Standard</code> scans have standard resource limits and use the full set of detectors to
     * analyze your code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code>
     *         type if missing.</p>
     *         <p>
     *         <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your
     *         code in near-real time. <code>Standard</code> scans have standard resource limits and use the full set of
     *         detectors to analyze your code.
     * @see ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag keys are
     * case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team name.
     * Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag
     *         keys are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team
     *         name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScanRequest)) {
            return false;
        }
        CreateScanRequest other = (CreateScanRequest) obj;
        return Objects.equals(analysisTypeAsString(), other.analysisTypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(scanName(), other.scanName()) && Objects.equals(scanTypeAsString(), other.scanTypeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScanRequest").add("AnalysisType", analysisTypeAsString())
                .add("ClientToken", clientToken()).add("ResourceId", resourceId()).add("ScanName", scanName())
                .add("ScanType", scanTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisType":
            return Optional.ofNullable(clazz.cast(analysisTypeAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "scanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScanRequest, T> g) {
        return obj -> g.apply((CreateScanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScanRequest> {
        /**
         * <p>
         * The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
         * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         * <code>All</code> type generates both security findings and quality findings. Defaults to
         * <code>Security</code> type if missing.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code>
         *        or <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         *        <code>All</code> type generates both security findings and quality findings. Defaults to
         *        <code>Security</code> type if missing.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(String analysisType);

        /**
         * <p>
         * The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or
         * <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         * <code>All</code> type generates both security findings and quality findings. Defaults to
         * <code>Security</code> type if missing.
         * </p>
         * 
         * @param analysisType
         *        The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code>
         *        or <code>All</code>. The <code>Security</code> type only generates findings related to security. The
         *        <code>All</code> type generates both security findings and quality findings. Defaults to
         *        <code>Security</code> type if missing.
         * @see AnalysisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisType
         */
        Builder analysisType(AnalysisType analysisType);

        /**
         * <p>
         * The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental
         * creation of duplicate scans if there are failures and retries.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the
         *        accidental creation of duplicate scans if there are failures and retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier for an input resource used to create a scan.
         * </p>
         * 
         * @param resourceId
         *        The identifier for an input resource used to create a scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(ResourceId resourceId);

        /**
         * <p>
         * The identifier for an input resource used to create a scan.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceId.Builder} avoiding the need to
         * create one manually via {@link ResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceId.Builder#build()} is called immediately and its result
         * is passed to {@link #resourceId(ResourceId)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on {@link ResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(ResourceId)
         */
        default Builder resourceId(Consumer<ResourceId.Builder> resourceId) {
            return resourceId(ResourceId.builder().applyMutation(resourceId).build());
        }

        /**
         * <p>
         * The unique name that CodeGuru Security uses to track revisions across multiple scans of the same resource.
         * Only allowed for a <code>STANDARD</code> scan type. If not specified, it will be auto generated.
         * </p>
         * 
         * @param scanName
         *        The unique name that CodeGuru Security uses to track revisions across multiple scans of the same
         *        resource. Only allowed for a <code>STANDARD</code> scan type. If not specified, it will be auto
         *        generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code>
         * type if missing.
         * </p>
         * <p>
         * <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your code
         * in near-real time. <code>Standard</code> scans have standard resource limits and use the full set of
         * detectors to analyze your code.
         * </p>
         * 
         * @param scanType
         *        The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to
         *        <code>Standard</code> type if missing.</p>
         *        <p>
         *        <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your
         *        code in near-real time. <code>Standard</code> scans have standard resource limits and use the full set
         *        of detectors to analyze your code.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(String scanType);

        /**
         * <p>
         * The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code>
         * type if missing.
         * </p>
         * <p>
         * <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your code
         * in near-real time. <code>Standard</code> scans have standard resource limits and use the full set of
         * detectors to analyze your code.
         * </p>
         * 
         * @param scanType
         *        The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to
         *        <code>Standard</code> type if missing.</p>
         *        <p>
         *        <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your
         *        code in near-real time. <code>Standard</code> scans have standard resource limits and use the full set
         *        of detectors to analyze your code.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(ScanType scanType);

        /**
         * <p>
         * An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag keys
         * are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team name.
         * Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag
         *        keys are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a
         *        team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruSecurityRequest.BuilderImpl implements Builder {
        private String analysisType;

        private String clientToken;

        private ResourceId resourceId;

        private String scanName;

        private String scanType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScanRequest model) {
            super(model);
            analysisType(model.analysisType);
            clientToken(model.clientToken);
            resourceId(model.resourceId);
            scanName(model.scanName);
            scanType(model.scanType);
            tags(model.tags);
        }

        public final String getAnalysisType() {
            return analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ResourceId.Builder getResourceId() {
            return resourceId != null ? resourceId.toBuilder() : null;
        }

        public final void setResourceId(ResourceId.BuilderImpl resourceId) {
            this.resourceId = resourceId != null ? resourceId.build() : null;
        }

        @Override
        public final Builder resourceId(ResourceId resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScanRequest build() {
            return new CreateScanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
