/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SuggestedFixesCopier {
    static List<SuggestedFix> copy(Collection<? extends SuggestedFix> suggestedFixesParam) {
        List<SuggestedFix> list;
        if (suggestedFixesParam == null || suggestedFixesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestedFix> modifiableList = new ArrayList<>();
            suggestedFixesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SuggestedFix> copyFromBuilder(Collection<? extends SuggestedFix.Builder> suggestedFixesParam) {
        List<SuggestedFix> list;
        if (suggestedFixesParam == null || suggestedFixesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestedFix> modifiableList = new ArrayList<>();
            suggestedFixesParam.forEach(entry -> {
                SuggestedFix member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SuggestedFix.Builder> copyToBuilder(Collection<? extends SuggestedFix> suggestedFixesParam) {
        List<SuggestedFix.Builder> list;
        if (suggestedFixesParam == null || suggestedFixesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestedFix.Builder> modifiableList = new ArrayList<>();
            suggestedFixesParam.forEach(entry -> {
                SuggestedFix.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
