/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFindingsResponse extends CodeGuruSecurityResponse implements
        ToCopyableBuilder<BatchGetFindingsResponse.Builder, BatchGetFindingsResponse> {
    private static final SdkField<List<BatchGetFindingsError>> FAILED_FINDINGS_FIELD = SdkField
            .<List<BatchGetFindingsError>> builder(MarshallingType.LIST)
            .memberName("failedFindings")
            .getter(getter(BatchGetFindingsResponse::failedFindings))
            .setter(setter(Builder::failedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetFindingsError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetFindingsError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField
            .<List<Finding>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(BatchGetFindingsResponse::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Finding> builder(MarshallingType.SDK_POJO)
                                            .constructor(Finding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FINDINGS_FIELD,
            FINDINGS_FIELD));

    private final List<BatchGetFindingsError> failedFindings;

    private final List<Finding> findings;

    private BatchGetFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.failedFindings = builder.failedFindings;
        this.findings = builder.findings;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedFindings() {
        return failedFindings != null && !(failedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the
     * <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedFindings} method.
     * </p>
     * 
     * @return A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the
     *         <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.
     */
    public final List<BatchGetFindingsError> failedFindings() {
        return failedFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Findings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all findings which were successfully fetched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindings} method.
     * </p>
     * 
     * @return A list of all findings which were successfully fetched.
     */
    public final List<Finding> findings() {
        return findings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedFindings() ? failedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsResponse)) {
            return false;
        }
        BatchGetFindingsResponse other = (BatchGetFindingsResponse) obj;
        return hasFailedFindings() == other.hasFailedFindings() && Objects.equals(failedFindings(), other.failedFindings())
                && hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFindingsResponse").add("FailedFindings", hasFailedFindings() ? failedFindings() : null)
                .add("Findings", hasFindings() ? findings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedFindings":
            return Optional.ofNullable(clazz.cast(failedFindings()));
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsResponse, T> g) {
        return obj -> g.apply((BatchGetFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetFindingsResponse> {
        /**
         * <p>
         * A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the
         * <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.
         * </p>
         * 
         * @param failedFindings
         *        A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains
         *        the <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error
         *        <code>message</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFindings(Collection<BatchGetFindingsError> failedFindings);

        /**
         * <p>
         * A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the
         * <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.
         * </p>
         * 
         * @param failedFindings
         *        A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains
         *        the <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error
         *        <code>message</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFindings(BatchGetFindingsError... failedFindings);

        /**
         * <p>
         * A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the
         * <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError.Builder#build()} is
         * called immediately and its result is passed to {@link #failedFindings(List<BatchGetFindingsError>)}.
         * 
         * @param failedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.BatchGetFindingsError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedFindings(java.util.Collection<BatchGetFindingsError>)
         */
        Builder failedFindings(Consumer<BatchGetFindingsError.Builder>... failedFindings);

        /**
         * <p>
         * A list of all findings which were successfully fetched.
         * </p>
         * 
         * @param findings
         *        A list of all findings which were successfully fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<Finding> findings);

        /**
         * <p>
         * A list of all findings which were successfully fetched.
         * </p>
         * 
         * @param findings
         *        A list of all findings which were successfully fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Finding... findings);

        /**
         * <p>
         * A list of all findings which were successfully fetched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codegurusecurity.model.Finding.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codegurusecurity.model.Finding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codegurusecurity.model.Finding.Builder#build()} is called immediately
         * and its result is passed to {@link #findings(List<Finding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codegurusecurity.model.Finding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(java.util.Collection<Finding>)
         */
        Builder findings(Consumer<Finding.Builder>... findings);
    }

    static final class BuilderImpl extends CodeGuruSecurityResponse.BuilderImpl implements Builder {
        private List<BatchGetFindingsError> failedFindings = DefaultSdkAutoConstructList.getInstance();

        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsResponse model) {
            super(model);
            failedFindings(model.failedFindings);
            findings(model.findings);
        }

        public final List<BatchGetFindingsError.Builder> getFailedFindings() {
            List<BatchGetFindingsError.Builder> result = BatchGetFindingsErrorsCopier.copyToBuilder(this.failedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedFindings(Collection<BatchGetFindingsError.BuilderImpl> failedFindings) {
            this.failedFindings = BatchGetFindingsErrorsCopier.copyFromBuilder(failedFindings);
        }

        @Override
        public final Builder failedFindings(Collection<BatchGetFindingsError> failedFindings) {
            this.failedFindings = BatchGetFindingsErrorsCopier.copy(failedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(BatchGetFindingsError... failedFindings) {
            failedFindings(Arrays.asList(failedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFindings(Consumer<BatchGetFindingsError.Builder>... failedFindings) {
            failedFindings(Stream.of(failedFindings).map(c -> BatchGetFindingsError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingsCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingsCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> Finding.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFindingsResponse build() {
            return new BatchGetFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
