/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action engine, or executor, related to the supported integration model used to create and update the action type.
 * The available executor types are <code>Lambda</code> and <code>JobWorker</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutorConfiguration.Builder, ExecutorConfiguration> {
    private static final SdkField<LambdaExecutorConfiguration> LAMBDA_EXECUTOR_CONFIGURATION_FIELD = SdkField
            .<LambdaExecutorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaExecutorConfiguration")
            .getter(getter(ExecutorConfiguration::lambdaExecutorConfiguration))
            .setter(setter(Builder::lambdaExecutorConfiguration))
            .constructor(LambdaExecutorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaExecutorConfiguration")
                    .build()).build();

    private static final SdkField<JobWorkerExecutorConfiguration> JOB_WORKER_EXECUTOR_CONFIGURATION_FIELD = SdkField
            .<JobWorkerExecutorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("jobWorkerExecutorConfiguration")
            .getter(getter(ExecutorConfiguration::jobWorkerExecutorConfiguration))
            .setter(setter(Builder::jobWorkerExecutorConfiguration))
            .constructor(JobWorkerExecutorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobWorkerExecutorConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAMBDA_EXECUTOR_CONFIGURATION_FIELD, JOB_WORKER_EXECUTOR_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final LambdaExecutorConfiguration lambdaExecutorConfiguration;

    private final JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration;

    private ExecutorConfiguration(BuilderImpl builder) {
        this.lambdaExecutorConfiguration = builder.lambdaExecutorConfiguration;
        this.jobWorkerExecutorConfiguration = builder.jobWorkerExecutorConfiguration;
    }

    /**
     * <p>
     * Details about the <code>Lambda</code> executor of the action type.
     * </p>
     * 
     * @return Details about the <code>Lambda</code> executor of the action type.
     */
    public final LambdaExecutorConfiguration lambdaExecutorConfiguration() {
        return lambdaExecutorConfiguration;
    }

    /**
     * <p>
     * Details about the <code>JobWorker</code> executor of the action type.
     * </p>
     * 
     * @return Details about the <code>JobWorker</code> executor of the action type.
     */
    public final JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration() {
        return jobWorkerExecutorConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaExecutorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(jobWorkerExecutorConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutorConfiguration)) {
            return false;
        }
        ExecutorConfiguration other = (ExecutorConfiguration) obj;
        return Objects.equals(lambdaExecutorConfiguration(), other.lambdaExecutorConfiguration())
                && Objects.equals(jobWorkerExecutorConfiguration(), other.jobWorkerExecutorConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutorConfiguration").add("LambdaExecutorConfiguration", lambdaExecutorConfiguration())
                .add("JobWorkerExecutorConfiguration", jobWorkerExecutorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaExecutorConfiguration":
            return Optional.ofNullable(clazz.cast(lambdaExecutorConfiguration()));
        case "jobWorkerExecutorConfiguration":
            return Optional.ofNullable(clazz.cast(jobWorkerExecutorConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutorConfiguration, T> g) {
        return obj -> g.apply((ExecutorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutorConfiguration> {
        /**
         * <p>
         * Details about the <code>Lambda</code> executor of the action type.
         * </p>
         * 
         * @param lambdaExecutorConfiguration
         *        Details about the <code>Lambda</code> executor of the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaExecutorConfiguration(LambdaExecutorConfiguration lambdaExecutorConfiguration);

        /**
         * <p>
         * Details about the <code>Lambda</code> executor of the action type.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaExecutorConfiguration.Builder} avoiding
         * the need to create one manually via {@link LambdaExecutorConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaExecutorConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaExecutorConfiguration(LambdaExecutorConfiguration)}.
         * 
         * @param lambdaExecutorConfiguration
         *        a consumer that will call methods on {@link LambdaExecutorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaExecutorConfiguration(LambdaExecutorConfiguration)
         */
        default Builder lambdaExecutorConfiguration(Consumer<LambdaExecutorConfiguration.Builder> lambdaExecutorConfiguration) {
            return lambdaExecutorConfiguration(LambdaExecutorConfiguration.builder().applyMutation(lambdaExecutorConfiguration)
                    .build());
        }

        /**
         * <p>
         * Details about the <code>JobWorker</code> executor of the action type.
         * </p>
         * 
         * @param jobWorkerExecutorConfiguration
         *        Details about the <code>JobWorker</code> executor of the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration);

        /**
         * <p>
         * Details about the <code>JobWorker</code> executor of the action type.
         * </p>
         * This is a convenience that creates an instance of the {@link JobWorkerExecutorConfiguration.Builder} avoiding
         * the need to create one manually via {@link JobWorkerExecutorConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobWorkerExecutorConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration)}.
         * 
         * @param jobWorkerExecutorConfiguration
         *        a consumer that will call methods on {@link JobWorkerExecutorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration)
         */
        default Builder jobWorkerExecutorConfiguration(
                Consumer<JobWorkerExecutorConfiguration.Builder> jobWorkerExecutorConfiguration) {
            return jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration.builder()
                    .applyMutation(jobWorkerExecutorConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaExecutorConfiguration lambdaExecutorConfiguration;

        private JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutorConfiguration model) {
            lambdaExecutorConfiguration(model.lambdaExecutorConfiguration);
            jobWorkerExecutorConfiguration(model.jobWorkerExecutorConfiguration);
        }

        public final LambdaExecutorConfiguration.Builder getLambdaExecutorConfiguration() {
            return lambdaExecutorConfiguration != null ? lambdaExecutorConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lambdaExecutorConfiguration(LambdaExecutorConfiguration lambdaExecutorConfiguration) {
            this.lambdaExecutorConfiguration = lambdaExecutorConfiguration;
            return this;
        }

        public final void setLambdaExecutorConfiguration(LambdaExecutorConfiguration.BuilderImpl lambdaExecutorConfiguration) {
            this.lambdaExecutorConfiguration = lambdaExecutorConfiguration != null ? lambdaExecutorConfiguration.build() : null;
        }

        public final JobWorkerExecutorConfiguration.Builder getJobWorkerExecutorConfiguration() {
            return jobWorkerExecutorConfiguration != null ? jobWorkerExecutorConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder jobWorkerExecutorConfiguration(JobWorkerExecutorConfiguration jobWorkerExecutorConfiguration) {
            this.jobWorkerExecutorConfiguration = jobWorkerExecutorConfiguration;
            return this;
        }

        public final void setJobWorkerExecutorConfiguration(
                JobWorkerExecutorConfiguration.BuilderImpl jobWorkerExecutorConfiguration) {
            this.jobWorkerExecutorConfiguration = jobWorkerExecutorConfiguration != null ? jobWorkerExecutorConfiguration.build()
                    : null;
        }

        @Override
        public ExecutorConfiguration build() {
            return new ExecutorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
