/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetPipeline</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPipelineResponse extends CodePipelineResponse implements
        ToCopyableBuilder<GetPipelineResponse.Builder, GetPipelineResponse> {
    private static final SdkField<PipelineDeclaration> PIPELINE_FIELD = SdkField
            .<PipelineDeclaration> builder(MarshallingType.SDK_POJO).memberName("pipeline")
            .getter(getter(GetPipelineResponse::pipeline)).setter(setter(Builder::pipeline))
            .constructor(PipelineDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()).build();

    private static final SdkField<PipelineMetadata> METADATA_FIELD = SdkField
            .<PipelineMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(GetPipelineResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(PipelineMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIPELINE_FIELD, METADATA_FIELD));

    private final PipelineDeclaration pipeline;

    private final PipelineMetadata metadata;

    private GetPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * Represents the structure of actions and stages to be performed in the pipeline.
     * </p>
     * 
     * @return Represents the structure of actions and stages to be performed in the pipeline.
     */
    public final PipelineDeclaration pipeline() {
        return pipeline;
    }

    /**
     * <p>
     * Represents the pipeline metadata information returned as part of the output of a <code>GetPipeline</code> action.
     * </p>
     * 
     * @return Represents the pipeline metadata information returned as part of the output of a <code>GetPipeline</code>
     *         action.
     */
    public final PipelineMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineResponse)) {
            return false;
        }
        GetPipelineResponse other = (GetPipelineResponse) obj;
        return Objects.equals(pipeline(), other.pipeline()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPipelineResponse").add("Pipeline", pipeline()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineResponse, T> g) {
        return obj -> g.apply((GetPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPipelineResponse> {
        /**
         * <p>
         * Represents the structure of actions and stages to be performed in the pipeline.
         * </p>
         * 
         * @param pipeline
         *        Represents the structure of actions and stages to be performed in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(PipelineDeclaration pipeline);

        /**
         * <p>
         * Represents the structure of actions and stages to be performed in the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineDeclaration.Builder} avoiding the need
         * to create one manually via {@link PipelineDeclaration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineDeclaration.Builder#build()} is called immediately and
         * its result is passed to {@link #pipeline(PipelineDeclaration)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link PipelineDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(PipelineDeclaration)
         */
        default Builder pipeline(Consumer<PipelineDeclaration.Builder> pipeline) {
            return pipeline(PipelineDeclaration.builder().applyMutation(pipeline).build());
        }

        /**
         * <p>
         * Represents the pipeline metadata information returned as part of the output of a <code>GetPipeline</code>
         * action.
         * </p>
         * 
         * @param metadata
         *        Represents the pipeline metadata information returned as part of the output of a
         *        <code>GetPipeline</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(PipelineMetadata metadata);

        /**
         * <p>
         * Represents the pipeline metadata information returned as part of the output of a <code>GetPipeline</code>
         * action.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineMetadata.Builder} avoiding the need to
         * create one manually via {@link PipelineMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(PipelineMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link PipelineMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(PipelineMetadata)
         */
        default Builder metadata(Consumer<PipelineMetadata.Builder> metadata) {
            return metadata(PipelineMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private PipelineDeclaration pipeline;

        private PipelineMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineResponse model) {
            super(model);
            pipeline(model.pipeline);
            metadata(model.metadata);
        }

        public final PipelineDeclaration.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(PipelineDeclaration.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        @Transient
        public final Builder pipeline(PipelineDeclaration pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final PipelineMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(PipelineMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(PipelineMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetPipelineResponse build() {
            return new GetPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
