/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetThirdPartyJobDetails</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThirdPartyJobDetailsResponse extends CodePipelineResponse implements
        ToCopyableBuilder<GetThirdPartyJobDetailsResponse.Builder, GetThirdPartyJobDetailsResponse> {
    private static final SdkField<ThirdPartyJobDetails> JOB_DETAILS_FIELD = SdkField
            .<ThirdPartyJobDetails> builder(MarshallingType.SDK_POJO).memberName("jobDetails")
            .getter(getter(GetThirdPartyJobDetailsResponse::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(ThirdPartyJobDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD));

    private final ThirdPartyJobDetails jobDetails;

    private GetThirdPartyJobDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDetails = builder.jobDetails;
    }

    /**
     * <p>
     * The details of the job, including any protected values defined for the job.
     * </p>
     * 
     * @return The details of the job, including any protected values defined for the job.
     */
    public final ThirdPartyJobDetails jobDetails() {
        return jobDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThirdPartyJobDetailsResponse)) {
            return false;
        }
        GetThirdPartyJobDetailsResponse other = (GetThirdPartyJobDetailsResponse) obj;
        return Objects.equals(jobDetails(), other.jobDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThirdPartyJobDetailsResponse").add("JobDetails", jobDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetThirdPartyJobDetailsResponse, T> g) {
        return obj -> g.apply((GetThirdPartyJobDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetThirdPartyJobDetailsResponse> {
        /**
         * <p>
         * The details of the job, including any protected values defined for the job.
         * </p>
         * 
         * @param jobDetails
         *        The details of the job, including any protected values defined for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(ThirdPartyJobDetails jobDetails);

        /**
         * <p>
         * The details of the job, including any protected values defined for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link ThirdPartyJobDetails.Builder} avoiding the need
         * to create one manually via {@link ThirdPartyJobDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThirdPartyJobDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #jobDetails(ThirdPartyJobDetails)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link ThirdPartyJobDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(ThirdPartyJobDetails)
         */
        default Builder jobDetails(Consumer<ThirdPartyJobDetails.Builder> jobDetails) {
            return jobDetails(ThirdPartyJobDetails.builder().applyMutation(jobDetails).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private ThirdPartyJobDetails jobDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThirdPartyJobDetailsResponse model) {
            super(model);
            jobDetails(model.jobDetails);
        }

        public final ThirdPartyJobDetails.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(ThirdPartyJobDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder jobDetails(ThirdPartyJobDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        @Override
        public GetThirdPartyJobDetailsResponse build() {
            return new GetThirdPartyJobDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
