/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about an artifact that is worked on by actions in the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Artifact implements SdkPojo, Serializable, ToCopyableBuilder<Artifact.Builder, Artifact> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Artifact::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(Artifact::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<ArtifactLocation> LOCATION_FIELD = SdkField
            .<ArtifactLocation> builder(MarshallingType.SDK_POJO).memberName("location").getter(getter(Artifact::location))
            .setter(setter(Builder::location)).constructor(ArtifactLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REVISION_FIELD,
            LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String revision;

    private final ArtifactLocation location;

    private Artifact(BuilderImpl builder) {
        this.name = builder.name;
        this.revision = builder.revision;
        this.location = builder.location;
    }

    /**
     * <p>
     * The artifact's name.
     * </p>
     * 
     * @return The artifact's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision ID
     * (Amazon S3).
     * </p>
     * 
     * @return The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a
     *         revision ID (Amazon S3).
     */
    public final String revision() {
        return revision;
    }

    /**
     * <p>
     * The location of an artifact.
     * </p>
     * 
     * @return The location of an artifact.
     */
    public final ArtifactLocation location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(revision(), other.revision())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Artifact").add("Name", name()).add("Revision", revision()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artifact, T> g) {
        return obj -> g.apply((Artifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Artifact> {
        /**
         * <p>
         * The artifact's name.
         * </p>
         * 
         * @param name
         *        The artifact's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a revision
         * ID (Amazon S3).
         * </p>
         * 
         * @param revision
         *        The artifact's revision ID. Depending on the type of object, this could be a commit ID (GitHub) or a
         *        revision ID (Amazon S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The location of an artifact.
         * </p>
         * 
         * @param location
         *        The location of an artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ArtifactLocation location);

        /**
         * <p>
         * The location of an artifact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArtifactLocation.Builder} avoiding the
         * need to create one manually via {@link ArtifactLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ArtifactLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ArtifactLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ArtifactLocation)
         */
        default Builder location(Consumer<ArtifactLocation.Builder> location) {
            return location(ArtifactLocation.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String revision;

        private ArtifactLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            name(model.name);
            revision(model.revision);
            location(model.location);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final ArtifactLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(ArtifactLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ArtifactLocation location) {
            this.location = location;
            return this;
        }

        @Override
        public Artifact build() {
            return new Artifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
