/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Artifact details for the action execution, such as the artifact location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactDetail implements SdkPojo, Serializable, ToCopyableBuilder<ArtifactDetail.Builder, ArtifactDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ArtifactDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("s3location").getter(getter(ArtifactDetail::s3location)).setter(setter(Builder::s3location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final S3Location s3location;

    private ArtifactDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.s3location = builder.s3location;
    }

    /**
     * <p>
     * The artifact object name for the action execution.
     * </p>
     * 
     * @return The artifact object name for the action execution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon S3 artifact location for the action execution.
     * </p>
     * 
     * @return The Amazon S3 artifact location for the action execution.
     */
    public final S3Location s3location() {
        return s3location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactDetail)) {
            return false;
        }
        ArtifactDetail other = (ArtifactDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(s3location(), other.s3location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactDetail").add("Name", name()).add("S3location", s3location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3location":
            return Optional.ofNullable(clazz.cast(s3location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactDetail, T> g) {
        return obj -> g.apply((ArtifactDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactDetail> {
        /**
         * <p>
         * The artifact object name for the action execution.
         * </p>
         * 
         * @param name
         *        The artifact object name for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon S3 artifact location for the action execution.
         * </p>
         * 
         * @param s3location
         *        The Amazon S3 artifact location for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3location(S3Location s3location);

        /**
         * <p>
         * The Amazon S3 artifact location for the action execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #s3location(S3Location)}.
         * 
         * @param s3location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3location(S3Location)
         */
        default Builder s3location(Consumer<S3Location.Builder> s3location) {
            return s3location(S3Location.builder().applyMutation(s3location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private S3Location s3location;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactDetail model) {
            name(model.name);
            s3location(model.s3location);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3Location.Builder getS3location() {
            return s3location != null ? s3location.toBuilder() : null;
        }

        public final void setS3location(S3Location.BuilderImpl s3location) {
            this.s3location = s3location != null ? s3location.build() : null;
        }

        @Override
        public final Builder s3location(S3Location s3location) {
            this.s3location = s3location;
            return this;
        }

        @Override
        public ArtifactDetail build() {
            return new ArtifactDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
