/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetActionTypeResponse extends CodePipelineResponse implements
        ToCopyableBuilder<GetActionTypeResponse.Builder, GetActionTypeResponse> {
    private static final SdkField<ActionTypeDeclaration> ACTION_TYPE_FIELD = SdkField
            .<ActionTypeDeclaration> builder(MarshallingType.SDK_POJO).memberName("actionType")
            .getter(getter(GetActionTypeResponse::actionType)).setter(setter(Builder::actionType))
            .constructor(ActionTypeDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD));

    private final ActionTypeDeclaration actionType;

    private GetActionTypeResponse(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
    }

    /**
     * <p>
     * The action type information for the requested action type, such as the action type ID.
     * </p>
     * 
     * @return The action type information for the requested action type, such as the action type ID.
     */
    public final ActionTypeDeclaration actionType() {
        return actionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActionTypeResponse)) {
            return false;
        }
        GetActionTypeResponse other = (GetActionTypeResponse) obj;
        return Objects.equals(actionType(), other.actionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetActionTypeResponse").add("ActionType", actionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetActionTypeResponse, T> g) {
        return obj -> g.apply((GetActionTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetActionTypeResponse> {
        /**
         * <p>
         * The action type information for the requested action type, such as the action type ID.
         * </p>
         * 
         * @param actionType
         *        The action type information for the requested action type, such as the action type ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(ActionTypeDeclaration actionType);

        /**
         * <p>
         * The action type information for the requested action type, such as the action type ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeDeclaration.Builder} avoiding
         * the need to create one manually via {@link ActionTypeDeclaration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTypeDeclaration.Builder#build()} is called immediately and
         * its result is passed to {@link #actionType(ActionTypeDeclaration)}.
         * 
         * @param actionType
         *        a consumer that will call methods on {@link ActionTypeDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionType(ActionTypeDeclaration)
         */
        default Builder actionType(Consumer<ActionTypeDeclaration.Builder> actionType) {
            return actionType(ActionTypeDeclaration.builder().applyMutation(actionType).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private ActionTypeDeclaration actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActionTypeResponse model) {
            super(model);
            actionType(model.actionType);
        }

        public final ActionTypeDeclaration.Builder getActionType() {
            return actionType != null ? actionType.toBuilder() : null;
        }

        public final void setActionType(ActionTypeDeclaration.BuilderImpl actionType) {
            this.actionType = actionType != null ? actionType.build() : null;
        }

        @Override
        public final Builder actionType(ActionTypeDeclaration actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public GetActionTypeResponse build() {
            return new GetActionTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
