/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PollForThirdPartyJobs</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForThirdPartyJobsRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PollForThirdPartyJobsRequest.Builder, PollForThirdPartyJobsRequest> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .memberName("actionTypeId").getter(getter(PollForThirdPartyJobsRequest::actionTypeId))
            .setter(setter(Builder::actionTypeId)).constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()).build();

    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBatchSize").getter(getter(PollForThirdPartyJobsRequest::maxBatchSize))
            .setter(setter(Builder::maxBatchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD,
            MAX_BATCH_SIZE_FIELD));

    private final ActionTypeId actionTypeId;

    private final Integer maxBatchSize;

    private PollForThirdPartyJobsRequest(BuilderImpl builder) {
        super(builder);
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
    }

    /**
     * <p>
     * Represents information about an action type.
     * </p>
     * 
     * @return Represents information about an action type.
     */
    public final ActionTypeId actionTypeId() {
        return actionTypeId;
    }

    /**
     * <p>
     * The maximum number of jobs to return in a poll for jobs call.
     * </p>
     * 
     * @return The maximum number of jobs to return in a poll for jobs call.
     */
    public final Integer maxBatchSize() {
        return maxBatchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(maxBatchSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsRequest)) {
            return false;
        }
        PollForThirdPartyJobsRequest other = (PollForThirdPartyJobsRequest) obj;
        return Objects.equals(actionTypeId(), other.actionTypeId()) && Objects.equals(maxBatchSize(), other.maxBatchSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PollForThirdPartyJobsRequest").add("ActionTypeId", actionTypeId())
                .add("MaxBatchSize", maxBatchSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypeId":
            return Optional.ofNullable(clazz.cast(actionTypeId()));
        case "maxBatchSize":
            return Optional.ofNullable(clazz.cast(maxBatchSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForThirdPartyJobsRequest, T> g) {
        return obj -> g.apply((PollForThirdPartyJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PollForThirdPartyJobsRequest> {
        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * 
         * @param actionTypeId
         *        Represents information about an action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypeId(ActionTypeId actionTypeId);

        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeId.Builder} avoiding the need
         * to create one manually via {@link ActionTypeId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypeId(ActionTypeId)}.
         * 
         * @param actionTypeId
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypeId(ActionTypeId)
         */
        default Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return actionTypeId(ActionTypeId.builder().applyMutation(actionTypeId).build());
        }

        /**
         * <p>
         * The maximum number of jobs to return in a poll for jobs call.
         * </p>
         * 
         * @param maxBatchSize
         *        The maximum number of jobs to return in a poll for jobs call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBatchSize(Integer maxBatchSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private ActionTypeId actionTypeId;

        private Integer maxBatchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsRequest model) {
            super(model);
            actionTypeId(model.actionTypeId);
            maxBatchSize(model.maxBatchSize);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return actionTypeId != null ? actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForThirdPartyJobsRequest build() {
            return new PollForThirdPartyJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
