/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdatePipeline</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineRequest extends CodePipelineRequest implements
        ToCopyableBuilder<UpdatePipelineRequest.Builder, UpdatePipelineRequest> {
    private static final SdkField<PipelineDeclaration> PIPELINE_FIELD = SdkField
            .<PipelineDeclaration> builder(MarshallingType.SDK_POJO).memberName("pipeline")
            .getter(getter(UpdatePipelineRequest::pipeline)).setter(setter(Builder::pipeline))
            .constructor(PipelineDeclaration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD));

    private final PipelineDeclaration pipeline;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
    }

    /**
     * <p>
     * The name of the pipeline to be updated.
     * </p>
     * 
     * @return The name of the pipeline to be updated.
     */
    public final PipelineDeclaration pipeline() {
        return pipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest) obj;
        return Objects.equals(pipeline(), other.pipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineRequest").add("Pipeline", pipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline to be updated.
         * </p>
         * 
         * @param pipeline
         *        The name of the pipeline to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(PipelineDeclaration pipeline);

        /**
         * <p>
         * The name of the pipeline to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineDeclaration.Builder} avoiding the
         * need to create one manually via {@link PipelineDeclaration#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineDeclaration.Builder#build()} is called immediately and
         * its result is passed to {@link #pipeline(PipelineDeclaration)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link PipelineDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(PipelineDeclaration)
         */
        default Builder pipeline(Consumer<PipelineDeclaration.Builder> pipeline) {
            return pipeline(PipelineDeclaration.builder().applyMutation(pipeline).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private PipelineDeclaration pipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            pipeline(model.pipeline);
        }

        public final PipelineDeclaration.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(PipelineDeclaration.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(PipelineDeclaration pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
