/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about parameters for artifacts associated with the action type, such as the minimum and maximum artifacts
 * allowed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeArtifactDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionTypeArtifactDetails.Builder, ActionTypeArtifactDetails> {
    private static final SdkField<Integer> MINIMUM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumCount").getter(getter(ActionTypeArtifactDetails::minimumCount))
            .setter(setter(Builder::minimumCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCount").build()).build();

    private static final SdkField<Integer> MAXIMUM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumCount").getter(getter(ActionTypeArtifactDetails::maximumCount))
            .setter(setter(Builder::maximumCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_COUNT_FIELD,
            MAXIMUM_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minimumCount;

    private final Integer maximumCount;

    private ActionTypeArtifactDetails(BuilderImpl builder) {
        this.minimumCount = builder.minimumCount;
        this.maximumCount = builder.maximumCount;
    }

    /**
     * <p>
     * The minimum number of artifacts that can be used with the action type. For example, you should specify a minimum
     * and maximum of zero input artifacts for an action type with a category of <code>source</code>.
     * </p>
     * 
     * @return The minimum number of artifacts that can be used with the action type. For example, you should specify a
     *         minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.
     */
    public final Integer minimumCount() {
        return minimumCount;
    }

    /**
     * <p>
     * The maximum number of artifacts that can be used with the actiontype. For example, you should specify a minimum
     * and maximum of zero input artifacts for an action type with a category of <code>source</code>.
     * </p>
     * 
     * @return The maximum number of artifacts that can be used with the actiontype. For example, you should specify a
     *         minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.
     */
    public final Integer maximumCount() {
        return maximumCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeArtifactDetails)) {
            return false;
        }
        ActionTypeArtifactDetails other = (ActionTypeArtifactDetails) obj;
        return Objects.equals(minimumCount(), other.minimumCount()) && Objects.equals(maximumCount(), other.maximumCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeArtifactDetails").add("MinimumCount", minimumCount())
                .add("MaximumCount", maximumCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minimumCount":
            return Optional.ofNullable(clazz.cast(minimumCount()));
        case "maximumCount":
            return Optional.ofNullable(clazz.cast(maximumCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeArtifactDetails, T> g) {
        return obj -> g.apply((ActionTypeArtifactDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeArtifactDetails> {
        /**
         * <p>
         * The minimum number of artifacts that can be used with the action type. For example, you should specify a
         * minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.
         * </p>
         * 
         * @param minimumCount
         *        The minimum number of artifacts that can be used with the action type. For example, you should specify
         *        a minimum and maximum of zero input artifacts for an action type with a category of
         *        <code>source</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCount(Integer minimumCount);

        /**
         * <p>
         * The maximum number of artifacts that can be used with the actiontype. For example, you should specify a
         * minimum and maximum of zero input artifacts for an action type with a category of <code>source</code>.
         * </p>
         * 
         * @param maximumCount
         *        The maximum number of artifacts that can be used with the actiontype. For example, you should specify
         *        a minimum and maximum of zero input artifacts for an action type with a category of
         *        <code>source</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumCount(Integer maximumCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumCount;

        private Integer maximumCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeArtifactDetails model) {
            minimumCount(model.minimumCount);
            maximumCount(model.maximumCount);
        }

        public final Integer getMinimumCount() {
            return minimumCount;
        }

        public final void setMinimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
        }

        @Override
        @Transient
        public final Builder minimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
            return this;
        }

        public final Integer getMaximumCount() {
            return maximumCount;
        }

        public final void setMaximumCount(Integer maximumCount) {
            this.maximumCount = maximumCount;
        }

        @Override
        @Transient
        public final Builder maximumCount(Integer maximumCount) {
            this.maximumCount = maximumCount;
            return this;
        }

        @Override
        public ActionTypeArtifactDetails build() {
            return new ActionTypeArtifactDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
