/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DeleteCustomActionType</code> operation. The custom action will be marked as deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteCustomActionTypeRequest extends CodePipelineRequest implements
        ToCopyableBuilder<DeleteCustomActionTypeRequest.Builder, DeleteCustomActionTypeRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(DeleteCustomActionTypeRequest::categoryAsString))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(DeleteCustomActionTypeRequest::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(DeleteCustomActionTypeRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            PROVIDER_FIELD, VERSION_FIELD));

    private final String category;

    private final String provider;

    private final String version;

    private DeleteCustomActionTypeRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    /**
     * <p>
     * The category of the custom action that you want to delete, such as source or deploy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the custom action that you want to delete, such as source or deploy.
     * @see ActionCategory
     */
    public final ActionCategory category() {
        return ActionCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the custom action that you want to delete, such as source or deploy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the custom action that you want to delete, such as source or deploy.
     * @see ActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The provider of the service used in the custom action, such as AWS CodeDeploy.
     * </p>
     * 
     * @return The provider of the service used in the custom action, such as AWS CodeDeploy.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The version of the custom action to delete.
     * </p>
     * 
     * @return The version of the custom action to delete.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomActionTypeRequest)) {
            return false;
        }
        DeleteCustomActionTypeRequest other = (DeleteCustomActionTypeRequest) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(provider(), other.provider())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteCustomActionTypeRequest").add("Category", categoryAsString()).add("Provider", provider())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCustomActionTypeRequest, T> g) {
        return obj -> g.apply((DeleteCustomActionTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteCustomActionTypeRequest> {
        /**
         * <p>
         * The category of the custom action that you want to delete, such as source or deploy.
         * </p>
         * 
         * @param category
         *        The category of the custom action that you want to delete, such as source or deploy.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the custom action that you want to delete, such as source or deploy.
         * </p>
         * 
         * @param category
         *        The category of the custom action that you want to delete, such as source or deploy.
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(ActionCategory category);

        /**
         * <p>
         * The provider of the service used in the custom action, such as AWS CodeDeploy.
         * </p>
         * 
         * @param provider
         *        The provider of the service used in the custom action, such as AWS CodeDeploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The version of the custom action to delete.
         * </p>
         * 
         * @param version
         *        The version of the custom action to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String category;

        private String provider;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomActionTypeRequest model) {
            super(model);
            category(model.category);
            provider(model.provider);
            version(model.version);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        @Transient
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        @Transient
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomActionTypeRequest build() {
            return new DeleteCustomActionTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
