/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the run of a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageExecution implements SdkPojo, Serializable, ToCopyableBuilder<StageExecution.Builder, StageExecution> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(StageExecution::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StageExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionId;

    private final String status;

    private StageExecution(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the pipeline execution associated with the stage.
     * </p>
     * 
     * @return The ID of the pipeline execution associated with the stage.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The status of the stage, or for a completed stage, the last status of the stage.
     * </p>
     * <note>
     * <p>
     * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be
     * completed.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StageExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
     *         <p>
     *         A status of cancelled means that the pipeline’s definition was updated before the stage execution could
     *         be completed.
     *         </p>
     * @see StageExecutionStatus
     */
    public final StageExecutionStatus status() {
        return StageExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the stage, or for a completed stage, the last status of the stage.
     * </p>
     * <note>
     * <p>
     * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be
     * completed.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StageExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
     *         <p>
     *         A status of cancelled means that the pipeline’s definition was updated before the stage execution could
     *         be completed.
     *         </p>
     * @see StageExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageExecution)) {
            return false;
        }
        StageExecution other = (StageExecution) obj;
        return Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageExecution").add("PipelineExecutionId", pipelineExecutionId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageExecution, T> g) {
        return obj -> g.apply((StageExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageExecution> {
        /**
         * <p>
         * The ID of the pipeline execution associated with the stage.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The ID of the pipeline execution associated with the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The status of the stage, or for a completed stage, the last status of the stage.
         * </p>
         * <note>
         * <p>
         * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be
         * completed.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
         *        <p>
         *        A status of cancelled means that the pipeline’s definition was updated before the stage execution
         *        could be completed.
         *        </p>
         * @see StageExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stage, or for a completed stage, the last status of the stage.
         * </p>
         * <note>
         * <p>
         * A status of cancelled means that the pipeline’s definition was updated before the stage execution could be
         * completed.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the stage, or for a completed stage, the last status of the stage.</p> <note>
         *        <p>
         *        A status of cancelled means that the pipeline’s definition was updated before the stage execution
         *        could be completed.
         *        </p>
         * @see StageExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageExecutionStatus
         */
        Builder status(StageExecutionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StageExecution model) {
            pipelineExecutionId(model.pipelineExecutionId);
            status(model.status);
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StageExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StageExecution build() {
            return new StageExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
