/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopPipelineExecutionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<StopPipelineExecutionRequest.Builder, StopPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(StopPipelineExecutionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(StopPipelineExecutionRequest::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<Boolean> ABANDON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("abandon").getter(getter(StopPipelineExecutionRequest::abandon)).setter(setter(Builder::abandon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abandon").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(StopPipelineExecutionRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_EXECUTION_ID_FIELD, ABANDON_FIELD, REASON_FIELD));

    private final String pipelineName;

    private final String pipelineExecutionId;

    private final Boolean abandon;

    private final String reason;

    private StopPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.abandon = builder.abandon;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of the pipeline to stop.
     * </p>
     * 
     * @return The name of the pipeline to stop.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code> action
     * to retrieve the current pipelineExecutionId.
     * </p>
     * 
     * @return The ID of the pipeline execution to be stopped in the current stage. Use the
     *         <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.
     * </p>
     * <note>
     * <p>
     * This option can lead to failed or out-of-sequence tasks.
     * </p>
     * </note>
     * 
     * @return Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress
     *         actions.</p> <note>
     *         <p>
     *         This option can lead to failed or out-of-sequence tasks.
     *         </p>
     */
    public final Boolean abandon() {
        return abandon;
    }

    /**
     * <p>
     * Use this option to enter comments, such as the reason the pipeline was stopped.
     * </p>
     * 
     * @return Use this option to enter comments, such as the reason the pipeline was stopped.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(abandon());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopPipelineExecutionRequest)) {
            return false;
        }
        StopPipelineExecutionRequest other = (StopPipelineExecutionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(abandon(), other.abandon()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopPipelineExecutionRequest").add("PipelineName", pipelineName())
                .add("PipelineExecutionId", pipelineExecutionId()).add("Abandon", abandon()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "abandon":
            return Optional.ofNullable(clazz.cast(abandon()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopPipelineExecutionRequest, T> g) {
        return obj -> g.apply((StopPipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopPipelineExecutionRequest> {
        /**
         * <p>
         * The name of the pipeline to stop.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The ID of the pipeline execution to be stopped in the current stage. Use the <code>GetPipelineState</code>
         * action to retrieve the current pipelineExecutionId.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The ID of the pipeline execution to be stopped in the current stage. Use the
         *        <code>GetPipelineState</code> action to retrieve the current pipelineExecutionId.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.
         * </p>
         * <note>
         * <p>
         * This option can lead to failed or out-of-sequence tasks.
         * </p>
         * </note>
         * 
         * @param abandon
         *        Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress
         *        actions.</p> <note>
         *        <p>
         *        This option can lead to failed or out-of-sequence tasks.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abandon(Boolean abandon);

        /**
         * <p>
         * Use this option to enter comments, such as the reason the pipeline was stopped.
         * </p>
         * 
         * @param reason
         *        Use this option to enter comments, such as the reason the pipeline was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String pipelineExecutionId;

        private Boolean abandon;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopPipelineExecutionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineExecutionId(model.pipelineExecutionId);
            abandon(model.abandon);
            reason(model.reason);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final Boolean getAbandon() {
            return abandon;
        }

        public final void setAbandon(Boolean abandon) {
            this.abandon = abandon;
        }

        @Override
        @Transient
        public final Builder abandon(Boolean abandon) {
            this.abandon = abandon;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        @Transient
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopPipelineExecutionRequest build() {
            return new StopPipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
