/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Job::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<JobData> DATA_FIELD = SdkField.<JobData> builder(MarshallingType.SDK_POJO).memberName("data")
            .getter(getter(Job::data)).setter(setter(Builder::data)).constructor(JobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> NONCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nonce")
            .getter(getter(Job::nonce)).setter(setter(Builder::nonce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonce").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Job::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD,
            NONCE_FIELD, ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final JobData data;

    private final String nonce;

    private final String accountId;

    private Job(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.nonce = builder.nonce;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The unique system-generated ID of the job.
     * </p>
     * 
     * @return The unique system-generated ID of the job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Other data about a job.
     * </p>
     * 
     * @return Other data about a job.
     */
    public final JobData data() {
        return data;
    }

    /**
     * <p>
     * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one
     * job worker. Use this number in an <a>AcknowledgeJob</a> request.
     * </p>
     * 
     * @return A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by
     *         only one job worker. Use this number in an <a>AcknowledgeJob</a> request.
     */
    public final String nonce() {
        return nonce;
    }

    /**
     * <p>
     * The ID of the AWS account to use when performing the job.
     * </p>
     * 
     * @return The ID of the AWS account to use when performing the job.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(nonce());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(data(), other.data()) && Objects.equals(nonce(), other.nonce())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Job").add("Id", id()).add("Data", data()).add("Nonce", nonce()).add("AccountId", accountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "nonce":
            return Optional.ofNullable(clazz.cast(nonce()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * The unique system-generated ID of the job.
         * </p>
         * 
         * @param id
         *        The unique system-generated ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Other data about a job.
         * </p>
         * 
         * @param data
         *        Other data about a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(JobData data);

        /**
         * <p>
         * Other data about a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobData.Builder} avoiding the need to
         * create one manually via {@link JobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobData.Builder#build()} is called immediately and its result is
         * passed to {@link #data(JobData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link JobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(JobData)
         */
        default Builder data(Consumer<JobData.Builder> data) {
            return data(JobData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only
         * one job worker. Use this number in an <a>AcknowledgeJob</a> request.
         * </p>
         * 
         * @param nonce
         *        A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on
         *        by only one job worker. Use this number in an <a>AcknowledgeJob</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonce(String nonce);

        /**
         * <p>
         * The ID of the AWS account to use when performing the job.
         * </p>
         * 
         * @param accountId
         *        The ID of the AWS account to use when performing the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private JobData data;

        private String nonce;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            id(model.id);
            data(model.data);
            nonce(model.nonce);
            accountId(model.accountId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final JobData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final String getNonce() {
            return nonce;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
