/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A type of trigger configuration for Git-based source actions.
 * </p>
 * <note>
 * <p>
 * You can specify the Git configuration trigger type for all third-party Git-based source actions that are supported by
 * the <code>CodeStarSourceConnection</code> action type.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GitConfiguration.Builder, GitConfiguration> {
    private static final SdkField<String> SOURCE_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceActionName").getter(getter(GitConfiguration::sourceActionName))
            .setter(setter(Builder::sourceActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceActionName").build()).build();

    private static final SdkField<List<GitPushFilter>> PUSH_FIELD = SdkField
            .<List<GitPushFilter>> builder(MarshallingType.LIST)
            .memberName("push")
            .getter(getter(GitConfiguration::push))
            .setter(setter(Builder::push))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("push").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GitPushFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(GitPushFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ACTION_NAME_FIELD,
            PUSH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceActionName;

    private final List<GitPushFilter> push;

    private GitConfiguration(BuilderImpl builder) {
        this.sourceActionName = builder.sourceActionName;
        this.push = builder.push;
    }

    /**
     * <p>
     * The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The
     * trigger configuration will start the pipeline upon the specified change only.
     * </p>
     * <note>
     * <p>
     * You can only specify one trigger configuration per source action.
     * </p>
     * </note>
     * 
     * @return The name of the pipeline source action where the trigger configuration, such as Git tags, is specified.
     *         The trigger configuration will start the pipeline upon the specified change only.</p> <note>
     *         <p>
     *         You can only specify one trigger configuration per source action.
     *         </p>
     */
    public final String sourceActionName() {
        return sourceActionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Push property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPush() {
        return push != null && !(push instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with
     * details.
     * </p>
     * <note>
     * <p>
     * Git tags is the only supported event type.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPush} method.
     * </p>
     * 
     * @return The field where the repository event that will start the pipeline, such as pushing Git tags, is specified
     *         with details.</p> <note>
     *         <p>
     *         Git tags is the only supported event type.
     *         </p>
     */
    public final List<GitPushFilter> push() {
        return push;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceActionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPush() ? push() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitConfiguration)) {
            return false;
        }
        GitConfiguration other = (GitConfiguration) obj;
        return Objects.equals(sourceActionName(), other.sourceActionName()) && hasPush() == other.hasPush()
                && Objects.equals(push(), other.push());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitConfiguration").add("SourceActionName", sourceActionName())
                .add("Push", hasPush() ? push() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceActionName":
            return Optional.ofNullable(clazz.cast(sourceActionName()));
        case "push":
            return Optional.ofNullable(clazz.cast(push()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitConfiguration, T> g) {
        return obj -> g.apply((GitConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitConfiguration> {
        /**
         * <p>
         * The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. The
         * trigger configuration will start the pipeline upon the specified change only.
         * </p>
         * <note>
         * <p>
         * You can only specify one trigger configuration per source action.
         * </p>
         * </note>
         * 
         * @param sourceActionName
         *        The name of the pipeline source action where the trigger configuration, such as Git tags, is
         *        specified. The trigger configuration will start the pipeline upon the specified change only.</p>
         *        <note>
         *        <p>
         *        You can only specify one trigger configuration per source action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceActionName(String sourceActionName);

        /**
         * <p>
         * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified
         * with details.
         * </p>
         * <note>
         * <p>
         * Git tags is the only supported event type.
         * </p>
         * </note>
         * 
         * @param push
         *        The field where the repository event that will start the pipeline, such as pushing Git tags, is
         *        specified with details.</p> <note>
         *        <p>
         *        Git tags is the only supported event type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(Collection<GitPushFilter> push);

        /**
         * <p>
         * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified
         * with details.
         * </p>
         * <note>
         * <p>
         * Git tags is the only supported event type.
         * </p>
         * </note>
         * 
         * @param push
         *        The field where the repository event that will start the pipeline, such as pushing Git tags, is
         *        specified with details.</p> <note>
         *        <p>
         *        Git tags is the only supported event type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(GitPushFilter... push);

        /**
         * <p>
         * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified
         * with details.
         * </p>
         * <note>
         * <p>
         * Git tags is the only supported event type.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.GitPushFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.GitPushFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.GitPushFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #push(List<GitPushFilter>)}.
         * 
         * @param push
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.GitPushFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #push(java.util.Collection<GitPushFilter>)
         */
        Builder push(Consumer<GitPushFilter.Builder>... push);
    }

    static final class BuilderImpl implements Builder {
        private String sourceActionName;

        private List<GitPushFilter> push = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitConfiguration model) {
            sourceActionName(model.sourceActionName);
            push(model.push);
        }

        public final String getSourceActionName() {
            return sourceActionName;
        }

        public final void setSourceActionName(String sourceActionName) {
            this.sourceActionName = sourceActionName;
        }

        @Override
        public final Builder sourceActionName(String sourceActionName) {
            this.sourceActionName = sourceActionName;
            return this;
        }

        public final List<GitPushFilter.Builder> getPush() {
            List<GitPushFilter.Builder> result = GitPushFilterListCopier.copyToBuilder(this.push);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPush(Collection<GitPushFilter.BuilderImpl> push) {
            this.push = GitPushFilterListCopier.copyFromBuilder(push);
        }

        @Override
        public final Builder push(Collection<GitPushFilter> push) {
            this.push = GitPushFilterListCopier.copy(push);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(GitPushFilter... push) {
            push(Arrays.asList(push));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(Consumer<GitPushFilter.Builder>... push) {
            push(Stream.of(push).map(c -> GitPushFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GitConfiguration build() {
            return new GitConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
