/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a rule configuration property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleConfigurationProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleConfigurationProperty.Builder, RuleConfigurationProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RuleConfigurationProperty::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("required").getter(getter(RuleConfigurationProperty::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<Boolean> KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("key")
            .getter(getter(RuleConfigurationProperty::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Boolean> SECRET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("secret").getter(getter(RuleConfigurationProperty::secret)).setter(setter(Builder::secret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()).build();

    private static final SdkField<Boolean> QUERYABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("queryable").getter(getter(RuleConfigurationProperty::queryable)).setter(setter(Builder::queryable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryable").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(RuleConfigurationProperty::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RuleConfigurationProperty::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REQUIRED_FIELD,
            KEY_FIELD, SECRET_FIELD, QUERYABLE_FIELD, DESCRIPTION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean required;

    private final Boolean key;

    private final Boolean secret;

    private final Boolean queryable;

    private final String description;

    private final String type;

    private RuleConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.key = builder.key;
        this.secret = builder.secret;
        this.queryable = builder.queryable;
        this.description = builder.description;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the rule configuration property.
     * </p>
     * 
     * @return The name of the rule configuration property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Whether the configuration property is a required value.
     * </p>
     * 
     * @return Whether the configuration property is a required value.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * Whether the configuration property is a key.
     * </p>
     * 
     * @return Whether the configuration property is a key.
     */
    public final Boolean key() {
        return key;
    }

    /**
     * <p>
     * Whether the configuration property is secret.
     * </p>
     * <p>
     * When updating a pipeline, passing * * * * * without changing any other values of the action preserves the
     * previous value of the secret.
     * </p>
     * 
     * @return Whether the configuration property is secret.</p>
     *         <p>
     *         When updating a pipeline, passing * * * * * without changing any other values of the action preserves the
     *         previous value of the secret.
     */
    public final Boolean secret() {
        return secret;
    }

    /**
     * <p>
     * Indicates whether the property can be queried.
     * </p>
     * <p>
     * If you create a pipeline with a condition and rule, and that rule contains a queryable property, the value for
     * that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20)
     * characters. The value can contain only alphanumeric characters, underscores, and hyphens.
     * </p>
     * 
     * @return Indicates whether the property can be queried.</p>
     *         <p>
     *         If you create a pipeline with a condition and rule, and that rule contains a queryable property, the
     *         value for that configuration property is subject to other restrictions. The value must be less than or
     *         equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and
     *         hyphens.
     */
    public final Boolean queryable() {
        return queryable;
    }

    /**
     * <p>
     * The description of the action configuration property that is displayed to users.
     * </p>
     * 
     * @return The description of the action configuration property that is displayed to users.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the configuration property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleConfigurationPropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the configuration property.
     * @see RuleConfigurationPropertyType
     */
    public final RuleConfigurationPropertyType type() {
        return RuleConfigurationPropertyType.fromValue(type);
    }

    /**
     * <p>
     * The type of the configuration property.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RuleConfigurationPropertyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the configuration property.
     * @see RuleConfigurationPropertyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(secret());
        hashCode = 31 * hashCode + Objects.hashCode(queryable());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfigurationProperty)) {
            return false;
        }
        RuleConfigurationProperty other = (RuleConfigurationProperty) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(required(), other.required())
                && Objects.equals(key(), other.key()) && Objects.equals(secret(), other.secret())
                && Objects.equals(queryable(), other.queryable()) && Objects.equals(description(), other.description())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleConfigurationProperty").add("Name", name()).add("Required", required()).add("Key", key())
                .add("Secret", secret()).add("Queryable", queryable()).add("Description", description())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "secret":
            return Optional.ofNullable(clazz.cast(secret()));
        case "queryable":
            return Optional.ofNullable(clazz.cast(queryable()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleConfigurationProperty, T> g) {
        return obj -> g.apply((RuleConfigurationProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleConfigurationProperty> {
        /**
         * <p>
         * The name of the rule configuration property.
         * </p>
         * 
         * @param name
         *        The name of the rule configuration property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether the configuration property is a required value.
         * </p>
         * 
         * @param required
         *        Whether the configuration property is a required value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * Whether the configuration property is a key.
         * </p>
         * 
         * @param key
         *        Whether the configuration property is a key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Boolean key);

        /**
         * <p>
         * Whether the configuration property is secret.
         * </p>
         * <p>
         * When updating a pipeline, passing * * * * * without changing any other values of the action preserves the
         * previous value of the secret.
         * </p>
         * 
         * @param secret
         *        Whether the configuration property is secret.</p>
         *        <p>
         *        When updating a pipeline, passing * * * * * without changing any other values of the action preserves
         *        the previous value of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secret(Boolean secret);

        /**
         * <p>
         * Indicates whether the property can be queried.
         * </p>
         * <p>
         * If you create a pipeline with a condition and rule, and that rule contains a queryable property, the value
         * for that configuration property is subject to other restrictions. The value must be less than or equal to
         * twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.
         * </p>
         * 
         * @param queryable
         *        Indicates whether the property can be queried.</p>
         *        <p>
         *        If you create a pipeline with a condition and rule, and that rule contains a queryable property, the
         *        value for that configuration property is subject to other restrictions. The value must be less than or
         *        equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and
         *        hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryable(Boolean queryable);

        /**
         * <p>
         * The description of the action configuration property that is displayed to users.
         * </p>
         * 
         * @param description
         *        The description of the action configuration property that is displayed to users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the configuration property.
         * </p>
         * 
         * @param type
         *        The type of the configuration property.
         * @see RuleConfigurationPropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleConfigurationPropertyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the configuration property.
         * </p>
         * 
         * @param type
         *        The type of the configuration property.
         * @see RuleConfigurationPropertyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleConfigurationPropertyType
         */
        Builder type(RuleConfigurationPropertyType type);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean required;

        private Boolean key;

        private Boolean secret;

        private Boolean queryable;

        private String description;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfigurationProperty model) {
            name(model.name);
            required(model.required);
            key(model.key);
            secret(model.secret);
            queryable(model.queryable);
            description(model.description);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Boolean getKey() {
            return key;
        }

        public final void setKey(Boolean key) {
            this.key = key;
        }

        @Override
        public final Builder key(Boolean key) {
            this.key = key;
            return this;
        }

        public final Boolean getSecret() {
            return secret;
        }

        public final void setSecret(Boolean secret) {
            this.secret = secret;
        }

        @Override
        public final Builder secret(Boolean secret) {
            this.secret = secret;
            return this;
        }

        public final Boolean getQueryable() {
            return queryable;
        }

        public final void setQueryable(Boolean queryable) {
            this.queryable = queryable;
        }

        @Override
        public final Builder queryable(Boolean queryable) {
            this.queryable = queryable;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleConfigurationPropertyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RuleConfigurationProperty build() {
            return new RuleConfigurationProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
