/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleTypeId implements SdkPojo, Serializable, ToCopyableBuilder<RuleTypeId.Builder, RuleTypeId> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(RuleTypeId::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(RuleTypeId::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(RuleTypeId::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(RuleTypeId::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, OWNER_FIELD,
            PROVIDER_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String owner;

    private final String provider;

    private final String version;

    private RuleTypeId(BuilderImpl builder) {
        this.category = builder.category;
        this.owner = builder.owner;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    /**
     * <p>
     * A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The
     * valid category is <code>Rule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RuleCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return A category defines what kind of rule can be run in the stage, and constrains the provider type for the
     *         rule. The valid category is <code>Rule</code>.
     * @see RuleCategory
     */
    public final RuleCategory category() {
        return RuleCategory.fromValue(category);
    }

    /**
     * <p>
     * A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule. The
     * valid category is <code>Rule</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link RuleCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return A category defines what kind of rule can be run in the stage, and constrains the provider type for the
     *         rule. The valid category is <code>Rule</code>.
     * @see RuleCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule category is
     * <code>AWS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link RuleOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule
     *         category is <code>AWS</code>.
     * @see RuleOwner
     */
    public final RuleOwner owner() {
        return RuleOwner.fromValue(owner);
    }

    /**
     * <p>
     * The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule category is
     * <code>AWS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link RuleOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule
     *         category is <code>AWS</code>.
     * @see RuleOwner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * <p>
     * The rule provider, such as the <code>DeploymentWindow</code> rule.
     * </p>
     * 
     * @return The rule provider, such as the <code>DeploymentWindow</code> rule.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * A string that describes the rule version.
     * </p>
     * 
     * @return A string that describes the rule version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTypeId)) {
            return false;
        }
        RuleTypeId other = (RuleTypeId) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(ownerAsString(), other.ownerAsString()) && Objects.equals(provider(), other.provider())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleTypeId").add("Category", categoryAsString()).add("Owner", ownerAsString())
                .add("Provider", provider()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleTypeId, T> g) {
        return obj -> g.apply((RuleTypeId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleTypeId> {
        /**
         * <p>
         * A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule.
         * The valid category is <code>Rule</code>.
         * </p>
         * 
         * @param category
         *        A category defines what kind of rule can be run in the stage, and constrains the provider type for the
         *        rule. The valid category is <code>Rule</code>.
         * @see RuleCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleCategory
         */
        Builder category(String category);

        /**
         * <p>
         * A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule.
         * The valid category is <code>Rule</code>.
         * </p>
         * 
         * @param category
         *        A category defines what kind of rule can be run in the stage, and constrains the provider type for the
         *        rule. The valid category is <code>Rule</code>.
         * @see RuleCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleCategory
         */
        Builder category(RuleCategory category);

        /**
         * <p>
         * The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule category
         * is <code>AWS</code>.
         * </p>
         * 
         * @param owner
         *        The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule
         *        category is <code>AWS</code>.
         * @see RuleOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOwner
         */
        Builder owner(String owner);

        /**
         * <p>
         * The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule category
         * is <code>AWS</code>.
         * </p>
         * 
         * @param owner
         *        The creator of the rule being called. The valid value for the <code>Owner</code> field in the rule
         *        category is <code>AWS</code>.
         * @see RuleOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOwner
         */
        Builder owner(RuleOwner owner);

        /**
         * <p>
         * The rule provider, such as the <code>DeploymentWindow</code> rule.
         * </p>
         * 
         * @param provider
         *        The rule provider, such as the <code>DeploymentWindow</code> rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * A string that describes the rule version.
         * </p>
         * 
         * @param version
         *        A string that describes the rule version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String owner;

        private String provider;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTypeId model) {
            category(model.category);
            owner(model.owner);
            provider(model.provider);
            version(model.version);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(RuleCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(RuleOwner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public RuleTypeId build() {
            return new RuleTypeId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
