/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideStageConditionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<OverrideStageConditionRequest.Builder, OverrideStageConditionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(OverrideStageConditionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(OverrideStageConditionRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(OverrideStageConditionRequest::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> CONDITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conditionType").getter(getter(OverrideStageConditionRequest::conditionTypeAsString))
            .setter(setter(Builder::conditionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, PIPELINE_EXECUTION_ID_FIELD, CONDITION_TYPE_FIELD));

    private final String pipelineName;

    private final String stageName;

    private final String pipelineExecutionId;

    private final String conditionType;

    private OverrideStageConditionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.conditionType = builder.conditionType;
    }

    /**
     * <p>
     * The name of the pipeline with the stage that will override the condition.
     * </p>
     * 
     * @return The name of the pipeline with the stage that will override the condition.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the stage for the override.
     * </p>
     * 
     * @return The name of the stage for the override.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The ID of the pipeline execution for the override.
     * </p>
     * 
     * @return The ID of the pipeline execution for the override.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The type of condition to override for the stage, such as entry conditions, failure conditions, or success
     * conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link ConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return The type of condition to override for the stage, such as entry conditions, failure conditions, or success
     *         conditions.
     * @see ConditionType
     */
    public final ConditionType conditionType() {
        return ConditionType.fromValue(conditionType);
    }

    /**
     * <p>
     * The type of condition to override for the stage, such as entry conditions, failure conditions, or success
     * conditions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link ConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return The type of condition to override for the stage, such as entry conditions, failure conditions, or success
     *         conditions.
     * @see ConditionType
     */
    public final String conditionTypeAsString() {
        return conditionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(conditionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideStageConditionRequest)) {
            return false;
        }
        OverrideStageConditionRequest other = (OverrideStageConditionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(conditionTypeAsString(), other.conditionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideStageConditionRequest").add("PipelineName", pipelineName())
                .add("StageName", stageName()).add("PipelineExecutionId", pipelineExecutionId())
                .add("ConditionType", conditionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "conditionType":
            return Optional.ofNullable(clazz.cast(conditionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverrideStageConditionRequest, T> g) {
        return obj -> g.apply((OverrideStageConditionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, OverrideStageConditionRequest> {
        /**
         * <p>
         * The name of the pipeline with the stage that will override the condition.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline with the stage that will override the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the stage for the override.
         * </p>
         * 
         * @param stageName
         *        The name of the stage for the override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The ID of the pipeline execution for the override.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The ID of the pipeline execution for the override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The type of condition to override for the stage, such as entry conditions, failure conditions, or success
         * conditions.
         * </p>
         * 
         * @param conditionType
         *        The type of condition to override for the stage, such as entry conditions, failure conditions, or
         *        success conditions.
         * @see ConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionType
         */
        Builder conditionType(String conditionType);

        /**
         * <p>
         * The type of condition to override for the stage, such as entry conditions, failure conditions, or success
         * conditions.
         * </p>
         * 
         * @param conditionType
         *        The type of condition to override for the stage, such as entry conditions, failure conditions, or
         *        success conditions.
         * @see ConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionType
         */
        Builder conditionType(ConditionType conditionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String pipelineExecutionId;

        private String conditionType;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideStageConditionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            pipelineExecutionId(model.pipelineExecutionId);
            conditionType(model.conditionType);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getConditionType() {
            return conditionType;
        }

        public final void setConditionType(String conditionType) {
            this.conditionType = conditionType;
        }

        @Override
        public final Builder conditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        @Override
        public final Builder conditionType(ConditionType conditionType) {
            this.conditionType(conditionType == null ? null : conditionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OverrideStageConditionRequest build() {
            return new OverrideStageConditionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
