/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the runs for a rule and the results produced on an artifact as it passes through stages in the
 * pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleExecutionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleExecutionDetail.Builder, RuleExecutionDetail> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(RuleExecutionDetail::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> RULE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleExecutionId").getter(getter(RuleExecutionDetail::ruleExecutionId))
            .setter(setter(Builder::ruleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionId").build()).build();

    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pipelineVersion").getter(getter(RuleExecutionDetail::pipelineVersion))
            .setter(setter(Builder::pipelineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(RuleExecutionDetail::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(RuleExecutionDetail::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(RuleExecutionDetail::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(RuleExecutionDetail::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(RuleExecutionDetail::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RuleExecutionDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<RuleExecutionInput> INPUT_FIELD = SdkField
            .<RuleExecutionInput> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(RuleExecutionDetail::input)).setter(setter(Builder::input)).constructor(RuleExecutionInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<RuleExecutionOutput> OUTPUT_FIELD = SdkField
            .<RuleExecutionOutput> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(RuleExecutionDetail::output)).setter(setter(Builder::output))
            .constructor(RuleExecutionOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD,
            RULE_EXECUTION_ID_FIELD, PIPELINE_VERSION_FIELD, STAGE_NAME_FIELD, RULE_NAME_FIELD, START_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD, UPDATED_BY_FIELD, STATUS_FIELD, INPUT_FIELD, OUTPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionId;

    private final String ruleExecutionId;

    private final Integer pipelineVersion;

    private final String stageName;

    private final String ruleName;

    private final Instant startTime;

    private final Instant lastUpdateTime;

    private final String updatedBy;

    private final String status;

    private final RuleExecutionInput input;

    private final RuleExecutionOutput output;

    private RuleExecutionDetail(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.ruleExecutionId = builder.ruleExecutionId;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageName = builder.stageName;
        this.ruleName = builder.ruleName;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.updatedBy = builder.updatedBy;
        this.status = builder.status;
        this.input = builder.input;
        this.output = builder.output;
    }

    /**
     * <p>
     * The ID of the pipeline execution in the stage where the rule was run. Use the <a>GetPipelineState</a> action to
     * retrieve the current pipelineExecutionId of the stage.
     * </p>
     * 
     * @return The ID of the pipeline execution in the stage where the rule was run. Use the <a>GetPipelineState</a>
     *         action to retrieve the current pipelineExecutionId of the stage.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The ID of the run for the rule.
     * </p>
     * 
     * @return The ID of the run for the rule.
     */
    public final String ruleExecutionId() {
        return ruleExecutionId;
    }

    /**
     * <p>
     * The version number of the pipeline with the stage where the rule was run.
     * </p>
     * 
     * @return The version number of the pipeline with the stage where the rule was run.
     */
    public final Integer pipelineVersion() {
        return pipelineVersion;
    }

    /**
     * <p>
     * The name of the stage where the rule was run.
     * </p>
     * 
     * @return The name of the stage where the rule was run.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The name of the rule that was run in the stage.
     * </p>
     * 
     * @return The name of the rule that was run in the stage.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The start time of the rule execution.
     * </p>
     * 
     * @return The start time of the rule execution.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time of the last change to the rule execution, in timestamp format.
     * </p>
     * 
     * @return The date and time of the last change to the rule execution, in timestamp format.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The ARN of the user who changed the rule execution details.
     * </p>
     * 
     * @return The ARN of the user who changed the rule execution details.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>,
     *         and <code>Failed</code>.
     * @see RuleExecutionStatus
     */
    public final RuleExecutionStatus status() {
        return RuleExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
     * <code>Failed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>,
     *         and <code>Failed</code>.
     * @see RuleExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Input details for the rule execution, such as role ARN, Region, and input artifacts.
     * </p>
     * 
     * @return Input details for the rule execution, such as role ARN, Region, and input artifacts.
     */
    public final RuleExecutionInput input() {
        return input;
    }

    /**
     * <p>
     * Output details for the rule execution, such as the rule execution result.
     * </p>
     * 
     * @return Output details for the rule execution, such as the rule execution result.
     */
    public final RuleExecutionOutput output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecutionDetail)) {
            return false;
        }
        RuleExecutionDetail other = (RuleExecutionDetail) obj;
        return Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(ruleExecutionId(), other.ruleExecutionId())
                && Objects.equals(pipelineVersion(), other.pipelineVersion()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(ruleName(), other.ruleName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(input(), other.input())
                && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleExecutionDetail").add("PipelineExecutionId", pipelineExecutionId())
                .add("RuleExecutionId", ruleExecutionId()).add("PipelineVersion", pipelineVersion())
                .add("StageName", stageName()).add("RuleName", ruleName()).add("StartTime", startTime())
                .add("LastUpdateTime", lastUpdateTime()).add("UpdatedBy", updatedBy()).add("Status", statusAsString())
                .add("Input", input()).add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "ruleExecutionId":
            return Optional.ofNullable(clazz.cast(ruleExecutionId()));
        case "pipelineVersion":
            return Optional.ofNullable(clazz.cast(pipelineVersion()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleExecutionDetail, T> g) {
        return obj -> g.apply((RuleExecutionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleExecutionDetail> {
        /**
         * <p>
         * The ID of the pipeline execution in the stage where the rule was run. Use the <a>GetPipelineState</a> action
         * to retrieve the current pipelineExecutionId of the stage.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The ID of the pipeline execution in the stage where the rule was run. Use the <a>GetPipelineState</a>
         *        action to retrieve the current pipelineExecutionId of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The ID of the run for the rule.
         * </p>
         * 
         * @param ruleExecutionId
         *        The ID of the run for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleExecutionId(String ruleExecutionId);

        /**
         * <p>
         * The version number of the pipeline with the stage where the rule was run.
         * </p>
         * 
         * @param pipelineVersion
         *        The version number of the pipeline with the stage where the rule was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersion(Integer pipelineVersion);

        /**
         * <p>
         * The name of the stage where the rule was run.
         * </p>
         * 
         * @param stageName
         *        The name of the stage where the rule was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The name of the rule that was run in the stage.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule that was run in the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The start time of the rule execution.
         * </p>
         * 
         * @param startTime
         *        The start time of the rule execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time of the last change to the rule execution, in timestamp format.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time of the last change to the rule execution, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The ARN of the user who changed the rule execution details.
         * </p>
         * 
         * @param updatedBy
         *        The ARN of the user who changed the rule execution details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
         * <code>Failed</code>.
         * </p>
         * 
         * @param status
         *        The status of the rule execution. Status categories are <code>InProgress</code>,
         *        <code>Succeeded</code>, and <code>Failed</code>.
         * @see RuleExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the rule execution. Status categories are <code>InProgress</code>, <code>Succeeded</code>, and
         * <code>Failed</code>.
         * </p>
         * 
         * @param status
         *        The status of the rule execution. Status categories are <code>InProgress</code>,
         *        <code>Succeeded</code>, and <code>Failed</code>.
         * @see RuleExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionStatus
         */
        Builder status(RuleExecutionStatus status);

        /**
         * <p>
         * Input details for the rule execution, such as role ARN, Region, and input artifacts.
         * </p>
         * 
         * @param input
         *        Input details for the rule execution, such as role ARN, Region, and input artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(RuleExecutionInput input);

        /**
         * <p>
         * Input details for the rule execution, such as role ARN, Region, and input artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleExecutionInput.Builder} avoiding the
         * need to create one manually via {@link RuleExecutionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleExecutionInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(RuleExecutionInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link RuleExecutionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(RuleExecutionInput)
         */
        default Builder input(Consumer<RuleExecutionInput.Builder> input) {
            return input(RuleExecutionInput.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Output details for the rule execution, such as the rule execution result.
         * </p>
         * 
         * @param output
         *        Output details for the rule execution, such as the rule execution result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(RuleExecutionOutput output);

        /**
         * <p>
         * Output details for the rule execution, such as the rule execution result.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleExecutionOutput.Builder} avoiding the
         * need to create one manually via {@link RuleExecutionOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleExecutionOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(RuleExecutionOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link RuleExecutionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(RuleExecutionOutput)
         */
        default Builder output(Consumer<RuleExecutionOutput.Builder> output) {
            return output(RuleExecutionOutput.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionId;

        private String ruleExecutionId;

        private Integer pipelineVersion;

        private String stageName;

        private String ruleName;

        private Instant startTime;

        private Instant lastUpdateTime;

        private String updatedBy;

        private String status;

        private RuleExecutionInput input;

        private RuleExecutionOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleExecutionDetail model) {
            pipelineExecutionId(model.pipelineExecutionId);
            ruleExecutionId(model.ruleExecutionId);
            pipelineVersion(model.pipelineVersion);
            stageName(model.stageName);
            ruleName(model.ruleName);
            startTime(model.startTime);
            lastUpdateTime(model.lastUpdateTime);
            updatedBy(model.updatedBy);
            status(model.status);
            input(model.input);
            output(model.output);
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getRuleExecutionId() {
            return ruleExecutionId;
        }

        public final void setRuleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
        }

        @Override
        public final Builder ruleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
            return this;
        }

        public final Integer getPipelineVersion() {
            return pipelineVersion;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RuleExecutionInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(RuleExecutionInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(RuleExecutionInput input) {
            this.input = input;
            return this;
        }

        public final RuleExecutionOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(RuleExecutionOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(RuleExecutionOutput output) {
            this.output = output;
            return this;
        }

        @Override
        public RuleExecutionDetail build() {
            return new RuleExecutionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
