/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rule type, which is made up of the combined values for category, owner, provider, and version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleType implements SdkPojo, Serializable, ToCopyableBuilder<RuleType.Builder, RuleType> {
    private static final SdkField<RuleTypeId> ID_FIELD = SdkField.<RuleTypeId> builder(MarshallingType.SDK_POJO).memberName("id")
            .getter(getter(RuleType::id)).setter(setter(Builder::id)).constructor(RuleTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<RuleTypeSettings> SETTINGS_FIELD = SdkField
            .<RuleTypeSettings> builder(MarshallingType.SDK_POJO).memberName("settings").getter(getter(RuleType::settings))
            .setter(setter(Builder::settings)).constructor(RuleTypeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<List<RuleConfigurationProperty>> RULE_CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<RuleConfigurationProperty>> builder(MarshallingType.LIST)
            .memberName("ruleConfigurationProperties")
            .getter(getter(RuleType::ruleConfigurationProperties))
            .setter(setter(Builder::ruleConfigurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfigurationProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleConfigurationProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleConfigurationProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("inputArtifactDetails")
            .getter(getter(RuleType::inputArtifactDetails)).setter(setter(Builder::inputArtifactDetails))
            .constructor(ArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SETTINGS_FIELD,
            RULE_CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RuleTypeId id;

    private final RuleTypeSettings settings;

    private final List<RuleConfigurationProperty> ruleConfigurationProperties;

    private final ArtifactDetails inputArtifactDetails;

    private RuleType(BuilderImpl builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        this.ruleConfigurationProperties = builder.ruleConfigurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
    }

    /**
     * <p>
     * Represents information about a rule type.
     * </p>
     * 
     * @return Represents information about a rule type.
     */
    public final RuleTypeId id() {
        return id;
    }

    /**
     * <p>
     * Returns information about the settings for a rule type.
     * </p>
     * 
     * @return Returns information about the settings for a rule type.
     */
    public final RuleTypeSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleConfigurationProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRuleConfigurationProperties() {
        return ruleConfigurationProperties != null && !(ruleConfigurationProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration properties for the rule type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleConfigurationProperties} method.
     * </p>
     * 
     * @return The configuration properties for the rule type.
     */
    public final List<RuleConfigurationProperty> ruleConfigurationProperties() {
        return ruleConfigurationProperties;
    }

    /**
     * Returns the value of the InputArtifactDetails property for this object.
     * 
     * @return The value of the InputArtifactDetails property for this object.
     */
    public final ArtifactDetails inputArtifactDetails() {
        return inputArtifactDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleConfigurationProperties() ? ruleConfigurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifactDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleType)) {
            return false;
        }
        RuleType other = (RuleType) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(settings(), other.settings())
                && hasRuleConfigurationProperties() == other.hasRuleConfigurationProperties()
                && Objects.equals(ruleConfigurationProperties(), other.ruleConfigurationProperties())
                && Objects.equals(inputArtifactDetails(), other.inputArtifactDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleType").add("Id", id()).add("Settings", settings())
                .add("RuleConfigurationProperties", hasRuleConfigurationProperties() ? ruleConfigurationProperties() : null)
                .add("InputArtifactDetails", inputArtifactDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ruleConfigurationProperties":
            return Optional.ofNullable(clazz.cast(ruleConfigurationProperties()));
        case "inputArtifactDetails":
            return Optional.ofNullable(clazz.cast(inputArtifactDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleType, T> g) {
        return obj -> g.apply((RuleType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleType> {
        /**
         * <p>
         * Represents information about a rule type.
         * </p>
         * 
         * @param id
         *        Represents information about a rule type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(RuleTypeId id);

        /**
         * <p>
         * Represents information about a rule type.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTypeId.Builder} avoiding the need to
         * create one manually via {@link RuleTypeId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTypeId.Builder#build()} is called immediately and its result
         * is passed to {@link #id(RuleTypeId)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link RuleTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(RuleTypeId)
         */
        default Builder id(Consumer<RuleTypeId.Builder> id) {
            return id(RuleTypeId.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * Returns information about the settings for a rule type.
         * </p>
         * 
         * @param settings
         *        Returns information about the settings for a rule type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(RuleTypeSettings settings);

        /**
         * <p>
         * Returns information about the settings for a rule type.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTypeSettings.Builder} avoiding the
         * need to create one manually via {@link RuleTypeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTypeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #settings(RuleTypeSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link RuleTypeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(RuleTypeSettings)
         */
        default Builder settings(Consumer<RuleTypeSettings.Builder> settings) {
            return settings(RuleTypeSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * The configuration properties for the rule type.
         * </p>
         * 
         * @param ruleConfigurationProperties
         *        The configuration properties for the rule type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfigurationProperties(Collection<RuleConfigurationProperty> ruleConfigurationProperties);

        /**
         * <p>
         * The configuration properties for the rule type.
         * </p>
         * 
         * @param ruleConfigurationProperties
         *        The configuration properties for the rule type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleConfigurationProperties(RuleConfigurationProperty... ruleConfigurationProperties);

        /**
         * <p>
         * The configuration properties for the rule type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #ruleConfigurationProperties(List<RuleConfigurationProperty>)}.
         * 
         * @param ruleConfigurationProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleConfigurationProperties(java.util.Collection<RuleConfigurationProperty>)
         */
        Builder ruleConfigurationProperties(Consumer<RuleConfigurationProperty.Builder>... ruleConfigurationProperties);

        /**
         * Sets the value of the InputArtifactDetails property for this object.
         *
         * @param inputArtifactDetails
         *        The new value for the InputArtifactDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails);

        /**
         * Sets the value of the InputArtifactDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ArtifactDetails.Builder} avoiding the
         * need to create one manually via {@link ArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #inputArtifactDetails(ArtifactDetails)}.
         * 
         * @param inputArtifactDetails
         *        a consumer that will call methods on {@link ArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifactDetails(ArtifactDetails)
         */
        default Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return inputArtifactDetails(ArtifactDetails.builder().applyMutation(inputArtifactDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleTypeId id;

        private RuleTypeSettings settings;

        private List<RuleConfigurationProperty> ruleConfigurationProperties = DefaultSdkAutoConstructList.getInstance();

        private ArtifactDetails inputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleType model) {
            id(model.id);
            settings(model.settings);
            ruleConfigurationProperties(model.ruleConfigurationProperties);
            inputArtifactDetails(model.inputArtifactDetails);
        }

        public final RuleTypeId.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(RuleTypeId.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(RuleTypeId id) {
            this.id = id;
            return this;
        }

        public final RuleTypeSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(RuleTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RuleTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<RuleConfigurationProperty.Builder> getRuleConfigurationProperties() {
            List<RuleConfigurationProperty.Builder> result = RuleConfigurationPropertyListCopier
                    .copyToBuilder(this.ruleConfigurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleConfigurationProperties(
                Collection<RuleConfigurationProperty.BuilderImpl> ruleConfigurationProperties) {
            this.ruleConfigurationProperties = RuleConfigurationPropertyListCopier.copyFromBuilder(ruleConfigurationProperties);
        }

        @Override
        public final Builder ruleConfigurationProperties(Collection<RuleConfigurationProperty> ruleConfigurationProperties) {
            this.ruleConfigurationProperties = RuleConfigurationPropertyListCopier.copy(ruleConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleConfigurationProperties(RuleConfigurationProperty... ruleConfigurationProperties) {
            ruleConfigurationProperties(Arrays.asList(ruleConfigurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleConfigurationProperties(
                Consumer<RuleConfigurationProperty.Builder>... ruleConfigurationProperties) {
            ruleConfigurationProperties(Stream.of(ruleConfigurationProperties)
                    .map(c -> RuleConfigurationProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return inputArtifactDetails != null ? inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        @Override
        public RuleType build() {
            return new RuleType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
