/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetryConfiguration.Builder, RetryConfiguration> {
    private static final SdkField<String> RETRY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retryMode").getter(getter(RetryConfiguration::retryModeAsString)).setter(setter(Builder::retryMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String retryMode;

    private RetryConfiguration(BuilderImpl builder) {
        this.retryMode = builder.retryMode;
    }

    /**
     * <p>
     * The method that you want to configure for automatic stage retry on stage failure. You can specify to retry only
     * failed action in the stage or all actions in the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryMode} will
     * return {@link StageRetryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryModeAsString}.
     * </p>
     * 
     * @return The method that you want to configure for automatic stage retry on stage failure. You can specify to
     *         retry only failed action in the stage or all actions in the stage.
     * @see StageRetryMode
     */
    public final StageRetryMode retryMode() {
        return StageRetryMode.fromValue(retryMode);
    }

    /**
     * <p>
     * The method that you want to configure for automatic stage retry on stage failure. You can specify to retry only
     * failed action in the stage or all actions in the stage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryMode} will
     * return {@link StageRetryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryModeAsString}.
     * </p>
     * 
     * @return The method that you want to configure for automatic stage retry on stage failure. You can specify to
     *         retry only failed action in the stage or all actions in the stage.
     * @see StageRetryMode
     */
    public final String retryModeAsString() {
        return retryMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retryModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryConfiguration)) {
            return false;
        }
        RetryConfiguration other = (RetryConfiguration) obj;
        return Objects.equals(retryModeAsString(), other.retryModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryConfiguration").add("RetryMode", retryModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retryMode":
            return Optional.ofNullable(clazz.cast(retryModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryConfiguration, T> g) {
        return obj -> g.apply((RetryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryConfiguration> {
        /**
         * <p>
         * The method that you want to configure for automatic stage retry on stage failure. You can specify to retry
         * only failed action in the stage or all actions in the stage.
         * </p>
         * 
         * @param retryMode
         *        The method that you want to configure for automatic stage retry on stage failure. You can specify to
         *        retry only failed action in the stage or all actions in the stage.
         * @see StageRetryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageRetryMode
         */
        Builder retryMode(String retryMode);

        /**
         * <p>
         * The method that you want to configure for automatic stage retry on stage failure. You can specify to retry
         * only failed action in the stage or all actions in the stage.
         * </p>
         * 
         * @param retryMode
         *        The method that you want to configure for automatic stage retry on stage failure. You can specify to
         *        retry only failed action in the stage or all actions in the stage.
         * @see StageRetryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageRetryMode
         */
        Builder retryMode(StageRetryMode retryMode);
    }

    static final class BuilderImpl implements Builder {
        private String retryMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryConfiguration model) {
            retryMode(model.retryMode);
        }

        public final String getRetryMode() {
            return retryMode;
        }

        public final void setRetryMode(String retryMode) {
            this.retryMode = retryMode;
        }

        @Override
        public final Builder retryMode(String retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        @Override
        public final Builder retryMode(StageRetryMode retryMode) {
            this.retryMode(retryMode == null ? null : retryMode.toString());
            return this;
        }

        @Override
        public RetryConfiguration build() {
            return new RetryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
