/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the context of an action in the stage of a pipeline to a job worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionContext implements SdkPojo, Serializable, ToCopyableBuilder<ActionContext.Builder, ActionContext> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ActionContext::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionExecutionId").getter(getter(ActionContext::actionExecutionId))
            .setter(setter(Builder::actionExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ACTION_EXECUTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String actionExecutionId;

    private ActionContext(BuilderImpl builder) {
        this.name = builder.name;
        this.actionExecutionId = builder.actionExecutionId;
    }

    /**
     * <p>
     * The name of the action in the context of a job.
     * </p>
     * 
     * @return The name of the action in the context of a job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The system-generated unique ID that corresponds to an action's execution.
     * </p>
     * 
     * @return The system-generated unique ID that corresponds to an action's execution.
     */
    public final String actionExecutionId() {
        return actionExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(actionExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(actionExecutionId(), other.actionExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionContext").add("Name", name()).add("ActionExecutionId", actionExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "actionExecutionId":
            return Optional.ofNullable(clazz.cast(actionExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("actionExecutionId", ACTION_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionContext, T> g) {
        return obj -> g.apply((ActionContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionContext> {
        /**
         * <p>
         * The name of the action in the context of a job.
         * </p>
         * 
         * @param name
         *        The name of the action in the context of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The system-generated unique ID that corresponds to an action's execution.
         * </p>
         * 
         * @param actionExecutionId
         *        The system-generated unique ID that corresponds to an action's execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionId(String actionExecutionId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String actionExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionContext model) {
            name(model.name);
            actionExecutionId(model.actionExecutionId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActionExecutionId() {
            return actionExecutionId;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        @Override
        public ActionContext build() {
            return new ActionContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
