/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the details of an action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionType implements SdkPojo, Serializable, ToCopyableBuilder<ActionType.Builder, ActionType> {
    private static final SdkField<ActionTypeId> ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .memberName("id").getter(getter(ActionType::id)).setter(setter(Builder::id)).constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ActionTypeSettings> SETTINGS_FIELD = SdkField
            .<ActionTypeSettings> builder(MarshallingType.SDK_POJO).memberName("settings").getter(getter(ActionType::settings))
            .setter(setter(Builder::settings)).constructor(ActionTypeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final SdkField<List<ActionConfigurationProperty>> ACTION_CONFIGURATION_PROPERTIES_FIELD = SdkField
            .<List<ActionConfigurationProperty>> builder(MarshallingType.LIST)
            .memberName("actionConfigurationProperties")
            .getter(getter(ActionType::actionConfigurationProperties))
            .setter(setter(Builder::actionConfigurationProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurationProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionConfigurationProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionConfigurationProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("inputArtifactDetails")
            .getter(getter(ActionType::inputArtifactDetails)).setter(setter(Builder::inputArtifactDetails))
            .constructor(ArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build())
            .build();

    private static final SdkField<ArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("outputArtifactDetails")
            .getter(getter(ActionType::outputArtifactDetails)).setter(setter(Builder::outputArtifactDetails))
            .constructor(ArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SETTINGS_FIELD,
            ACTION_CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD, OUTPUT_ARTIFACT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActionTypeId id;

    private final ActionTypeSettings settings;

    private final List<ActionConfigurationProperty> actionConfigurationProperties;

    private final ArtifactDetails inputArtifactDetails;

    private final ArtifactDetails outputArtifactDetails;

    private ActionType(BuilderImpl builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        this.actionConfigurationProperties = builder.actionConfigurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
    }

    /**
     * <p>
     * Represents information about an action type.
     * </p>
     * 
     * @return Represents information about an action type.
     */
    public final ActionTypeId id() {
        return id;
    }

    /**
     * <p>
     * The settings for the action type.
     * </p>
     * 
     * @return The settings for the action type.
     */
    public final ActionTypeSettings settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionConfigurationProperties property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActionConfigurationProperties() {
        return actionConfigurationProperties != null && !(actionConfigurationProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration properties for the action type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionConfigurationProperties} method.
     * </p>
     * 
     * @return The configuration properties for the action type.
     */
    public final List<ActionConfigurationProperty> actionConfigurationProperties() {
        return actionConfigurationProperties;
    }

    /**
     * <p>
     * The details of the input artifact for the action, such as its commit ID.
     * </p>
     * 
     * @return The details of the input artifact for the action, such as its commit ID.
     */
    public final ArtifactDetails inputArtifactDetails() {
        return inputArtifactDetails;
    }

    /**
     * <p>
     * The details of the output artifact of the action, such as its commit ID.
     * </p>
     * 
     * @return The details of the output artifact of the action, such as its commit ID.
     */
    public final ArtifactDetails outputArtifactDetails() {
        return outputArtifactDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionConfigurationProperties() ? actionConfigurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputArtifactDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionType)) {
            return false;
        }
        ActionType other = (ActionType) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(settings(), other.settings())
                && hasActionConfigurationProperties() == other.hasActionConfigurationProperties()
                && Objects.equals(actionConfigurationProperties(), other.actionConfigurationProperties())
                && Objects.equals(inputArtifactDetails(), other.inputArtifactDetails())
                && Objects.equals(outputArtifactDetails(), other.outputArtifactDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ActionType")
                .add("Id", id())
                .add("Settings", settings())
                .add("ActionConfigurationProperties", hasActionConfigurationProperties() ? actionConfigurationProperties() : null)
                .add("InputArtifactDetails", inputArtifactDetails()).add("OutputArtifactDetails", outputArtifactDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "actionConfigurationProperties":
            return Optional.ofNullable(clazz.cast(actionConfigurationProperties()));
        case "inputArtifactDetails":
            return Optional.ofNullable(clazz.cast(inputArtifactDetails()));
        case "outputArtifactDetails":
            return Optional.ofNullable(clazz.cast(outputArtifactDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("settings", SETTINGS_FIELD);
        map.put("actionConfigurationProperties", ACTION_CONFIGURATION_PROPERTIES_FIELD);
        map.put("inputArtifactDetails", INPUT_ARTIFACT_DETAILS_FIELD);
        map.put("outputArtifactDetails", OUTPUT_ARTIFACT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionType, T> g) {
        return obj -> g.apply((ActionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionType> {
        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * 
         * @param id
         *        Represents information about an action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(ActionTypeId id);

        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeId.Builder} avoiding the need
         * to create one manually via {@link ActionTypeId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #id(ActionTypeId)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(ActionTypeId)
         */
        default Builder id(Consumer<ActionTypeId.Builder> id) {
            return id(ActionTypeId.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * The settings for the action type.
         * </p>
         * 
         * @param settings
         *        The settings for the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(ActionTypeSettings settings);

        /**
         * <p>
         * The settings for the action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeSettings.Builder} avoiding the
         * need to create one manually via {@link ActionTypeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #settings(ActionTypeSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link ActionTypeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(ActionTypeSettings)
         */
        default Builder settings(Consumer<ActionTypeSettings.Builder> settings) {
            return settings(ActionTypeSettings.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * The configuration properties for the action type.
         * </p>
         * 
         * @param actionConfigurationProperties
         *        The configuration properties for the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties);

        /**
         * <p>
         * The configuration properties for the action type.
         * </p>
         * 
         * @param actionConfigurationProperties
         *        The configuration properties for the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConfigurationProperties(ActionConfigurationProperty... actionConfigurationProperties);

        /**
         * <p>
         * The configuration properties for the action type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #actionConfigurationProperties(List<ActionConfigurationProperty>)}.
         * 
         * @param actionConfigurationProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionConfigurationProperties(java.util.Collection<ActionConfigurationProperty>)
         */
        Builder actionConfigurationProperties(Consumer<ActionConfigurationProperty.Builder>... actionConfigurationProperties);

        /**
         * <p>
         * The details of the input artifact for the action, such as its commit ID.
         * </p>
         * 
         * @param inputArtifactDetails
         *        The details of the input artifact for the action, such as its commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails);

        /**
         * <p>
         * The details of the input artifact for the action, such as its commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArtifactDetails.Builder} avoiding the
         * need to create one manually via {@link ArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #inputArtifactDetails(ArtifactDetails)}.
         * 
         * @param inputArtifactDetails
         *        a consumer that will call methods on {@link ArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifactDetails(ArtifactDetails)
         */
        default Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return inputArtifactDetails(ArtifactDetails.builder().applyMutation(inputArtifactDetails).build());
        }

        /**
         * <p>
         * The details of the output artifact of the action, such as its commit ID.
         * </p>
         * 
         * @param outputArtifactDetails
         *        The details of the output artifact of the action, such as its commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails);

        /**
         * <p>
         * The details of the output artifact of the action, such as its commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArtifactDetails.Builder} avoiding the
         * need to create one manually via {@link ArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #outputArtifactDetails(ArtifactDetails)}.
         * 
         * @param outputArtifactDetails
         *        a consumer that will call methods on {@link ArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputArtifactDetails(ArtifactDetails)
         */
        default Builder outputArtifactDetails(Consumer<ArtifactDetails.Builder> outputArtifactDetails) {
            return outputArtifactDetails(ArtifactDetails.builder().applyMutation(outputArtifactDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActionTypeId id;

        private ActionTypeSettings settings;

        private List<ActionConfigurationProperty> actionConfigurationProperties = DefaultSdkAutoConstructList.getInstance();

        private ArtifactDetails inputArtifactDetails;

        private ArtifactDetails outputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionType model) {
            id(model.id);
            settings(model.settings);
            actionConfigurationProperties(model.actionConfigurationProperties);
            inputArtifactDetails(model.inputArtifactDetails);
            outputArtifactDetails(model.outputArtifactDetails);
        }

        public final ActionTypeId.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(ActionTypeId.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(ActionTypeId id) {
            this.id = id;
            return this;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ActionConfigurationProperty.Builder> getActionConfigurationProperties() {
            List<ActionConfigurationProperty.Builder> result = ActionConfigurationPropertyListCopier
                    .copyToBuilder(this.actionConfigurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurationProperties(
                Collection<ActionConfigurationProperty.BuilderImpl> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier
                    .copyFromBuilder(actionConfigurationProperties);
        }

        @Override
        public final Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier.copy(actionConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurationProperties(ActionConfigurationProperty... actionConfigurationProperties) {
            actionConfigurationProperties(Arrays.asList(actionConfigurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurationProperties(
                Consumer<ActionConfigurationProperty.Builder>... actionConfigurationProperties) {
            actionConfigurationProperties(Stream.of(actionConfigurationProperties)
                    .map(c -> ActionConfigurationProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return inputArtifactDetails != null ? inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return outputArtifactDetails != null ? outputArtifactDetails.toBuilder() : null;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        @Override
        public ActionType build() {
            return new ActionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
