/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for the action type definition that are provided when the action type is created or updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionTypeDeclaration.Builder, ActionTypeDeclaration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ActionTypeDeclaration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<ActionTypeExecutor> EXECUTOR_FIELD = SdkField
            .<ActionTypeExecutor> builder(MarshallingType.SDK_POJO).memberName("executor")
            .getter(getter(ActionTypeDeclaration::executor)).setter(setter(Builder::executor))
            .constructor(ActionTypeExecutor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executor").build()).build();

    private static final SdkField<ActionTypeIdentifier> ID_FIELD = SdkField
            .<ActionTypeIdentifier> builder(MarshallingType.SDK_POJO).memberName("id").getter(getter(ActionTypeDeclaration::id))
            .setter(setter(Builder::id)).constructor(ActionTypeIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ActionTypeArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ActionTypeArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("inputArtifactDetails")
            .getter(getter(ActionTypeDeclaration::inputArtifactDetails)).setter(setter(Builder::inputArtifactDetails))
            .constructor(ActionTypeArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build())
            .build();

    private static final SdkField<ActionTypeArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField
            .<ActionTypeArtifactDetails> builder(MarshallingType.SDK_POJO).memberName("outputArtifactDetails")
            .getter(getter(ActionTypeDeclaration::outputArtifactDetails)).setter(setter(Builder::outputArtifactDetails))
            .constructor(ActionTypeArtifactDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build())
            .build();

    private static final SdkField<ActionTypePermissions> PERMISSIONS_FIELD = SdkField
            .<ActionTypePermissions> builder(MarshallingType.SDK_POJO).memberName("permissions")
            .getter(getter(ActionTypeDeclaration::permissions)).setter(setter(Builder::permissions))
            .constructor(ActionTypePermissions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();

    private static final SdkField<List<ActionTypeProperty>> PROPERTIES_FIELD = SdkField
            .<List<ActionTypeProperty>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(ActionTypeDeclaration::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionTypeProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionTypeProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ActionTypeUrls> URLS_FIELD = SdkField.<ActionTypeUrls> builder(MarshallingType.SDK_POJO)
            .memberName("urls").getter(getter(ActionTypeDeclaration::urls)).setter(setter(Builder::urls))
            .constructor(ActionTypeUrls::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXECUTOR_FIELD, ID_FIELD, INPUT_ARTIFACT_DETAILS_FIELD, OUTPUT_ARTIFACT_DETAILS_FIELD, PERMISSIONS_FIELD,
            PROPERTIES_FIELD, URLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final ActionTypeExecutor executor;

    private final ActionTypeIdentifier id;

    private final ActionTypeArtifactDetails inputArtifactDetails;

    private final ActionTypeArtifactDetails outputArtifactDetails;

    private final ActionTypePermissions permissions;

    private final List<ActionTypeProperty> properties;

    private final ActionTypeUrls urls;

    private ActionTypeDeclaration(BuilderImpl builder) {
        this.description = builder.description;
        this.executor = builder.executor;
        this.id = builder.id;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
        this.permissions = builder.permissions;
        this.properties = builder.properties;
        this.urls = builder.urls;
    }

    /**
     * <p>
     * The description for the action type to be updated.
     * </p>
     * 
     * @return The description for the action type to be updated.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the executor for an action type that was created with any supported integration model.
     * </p>
     * 
     * @return Information about the executor for an action type that was created with any supported integration model.
     */
    public final ActionTypeExecutor executor() {
        return executor;
    }

    /**
     * <p>
     * The action category, owner, provider, and version of the action type to be updated.
     * </p>
     * 
     * @return The action category, owner, provider, and version of the action type to be updated.
     */
    public final ActionTypeIdentifier id() {
        return id;
    }

    /**
     * <p>
     * Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum and
     * maximum number of input artifacts allowed.
     * </p>
     * 
     * @return Details for the artifacts, such as application files, to be worked on by the action. For example, the
     *         minimum and maximum number of input artifacts allowed.
     */
    public final ActionTypeArtifactDetails inputArtifactDetails() {
        return inputArtifactDetails;
    }

    /**
     * <p>
     * Details for the output artifacts, such as a built application, that are the result of the action. For example,
     * the minimum and maximum number of output artifacts allowed.
     * </p>
     * 
     * @return Details for the output artifacts, such as a built application, that are the result of the action. For
     *         example, the minimum and maximum number of output artifacts allowed.
     */
    public final ActionTypeArtifactDetails outputArtifactDetails() {
        return outputArtifactDetails;
    }

    /**
     * <p>
     * Details identifying the accounts with permissions to use the action type.
     * </p>
     * 
     * @return Details identifying the accounts with permissions to use the action type.
     */
    public final ActionTypePermissions permissions() {
        return permissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of the action type to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties of the action type to be updated.
     */
    public final List<ActionTypeProperty> properties() {
        return properties;
    }

    /**
     * <p>
     * The links associated with the action type to be updated.
     * </p>
     * 
     * @return The links associated with the action type to be updated.
     */
    public final ActionTypeUrls urls() {
        return urls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(executor());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(urls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeDeclaration)) {
            return false;
        }
        ActionTypeDeclaration other = (ActionTypeDeclaration) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(executor(), other.executor())
                && Objects.equals(id(), other.id()) && Objects.equals(inputArtifactDetails(), other.inputArtifactDetails())
                && Objects.equals(outputArtifactDetails(), other.outputArtifactDetails())
                && Objects.equals(permissions(), other.permissions()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && Objects.equals(urls(), other.urls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeDeclaration").add("Description", description()).add("Executor", executor())
                .add("Id", id()).add("InputArtifactDetails", inputArtifactDetails())
                .add("OutputArtifactDetails", outputArtifactDetails()).add("Permissions", permissions())
                .add("Properties", hasProperties() ? properties() : null).add("Urls", urls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "executor":
            return Optional.ofNullable(clazz.cast(executor()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "inputArtifactDetails":
            return Optional.ofNullable(clazz.cast(inputArtifactDetails()));
        case "outputArtifactDetails":
            return Optional.ofNullable(clazz.cast(outputArtifactDetails()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "urls":
            return Optional.ofNullable(clazz.cast(urls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("executor", EXECUTOR_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputArtifactDetails", INPUT_ARTIFACT_DETAILS_FIELD);
        map.put("outputArtifactDetails", OUTPUT_ARTIFACT_DETAILS_FIELD);
        map.put("permissions", PERMISSIONS_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("urls", URLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeDeclaration, T> g) {
        return obj -> g.apply((ActionTypeDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeDeclaration> {
        /**
         * <p>
         * The description for the action type to be updated.
         * </p>
         * 
         * @param description
         *        The description for the action type to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the executor for an action type that was created with any supported integration model.
         * </p>
         * 
         * @param executor
         *        Information about the executor for an action type that was created with any supported integration
         *        model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executor(ActionTypeExecutor executor);

        /**
         * <p>
         * Information about the executor for an action type that was created with any supported integration model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeExecutor.Builder} avoiding the
         * need to create one manually via {@link ActionTypeExecutor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeExecutor.Builder#build()} is called immediately and its
         * result is passed to {@link #executor(ActionTypeExecutor)}.
         * 
         * @param executor
         *        a consumer that will call methods on {@link ActionTypeExecutor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executor(ActionTypeExecutor)
         */
        default Builder executor(Consumer<ActionTypeExecutor.Builder> executor) {
            return executor(ActionTypeExecutor.builder().applyMutation(executor).build());
        }

        /**
         * <p>
         * The action category, owner, provider, and version of the action type to be updated.
         * </p>
         * 
         * @param id
         *        The action category, owner, provider, and version of the action type to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(ActionTypeIdentifier id);

        /**
         * <p>
         * The action category, owner, provider, and version of the action type to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeIdentifier.Builder} avoiding
         * the need to create one manually via {@link ActionTypeIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeIdentifier.Builder#build()} is called immediately and
         * its result is passed to {@link #id(ActionTypeIdentifier)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link ActionTypeIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(ActionTypeIdentifier)
         */
        default Builder id(Consumer<ActionTypeIdentifier.Builder> id) {
            return id(ActionTypeIdentifier.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum
         * and maximum number of input artifacts allowed.
         * </p>
         * 
         * @param inputArtifactDetails
         *        Details for the artifacts, such as application files, to be worked on by the action. For example, the
         *        minimum and maximum number of input artifacts allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactDetails(ActionTypeArtifactDetails inputArtifactDetails);

        /**
         * <p>
         * Details for the artifacts, such as application files, to be worked on by the action. For example, the minimum
         * and maximum number of input artifacts allowed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeArtifactDetails.Builder}
         * avoiding the need to create one manually via {@link ActionTypeArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeArtifactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #inputArtifactDetails(ActionTypeArtifactDetails)}.
         * 
         * @param inputArtifactDetails
         *        a consumer that will call methods on {@link ActionTypeArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifactDetails(ActionTypeArtifactDetails)
         */
        default Builder inputArtifactDetails(Consumer<ActionTypeArtifactDetails.Builder> inputArtifactDetails) {
            return inputArtifactDetails(ActionTypeArtifactDetails.builder().applyMutation(inputArtifactDetails).build());
        }

        /**
         * <p>
         * Details for the output artifacts, such as a built application, that are the result of the action. For
         * example, the minimum and maximum number of output artifacts allowed.
         * </p>
         * 
         * @param outputArtifactDetails
         *        Details for the output artifacts, such as a built application, that are the result of the action. For
         *        example, the minimum and maximum number of output artifacts allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifactDetails(ActionTypeArtifactDetails outputArtifactDetails);

        /**
         * <p>
         * Details for the output artifacts, such as a built application, that are the result of the action. For
         * example, the minimum and maximum number of output artifacts allowed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeArtifactDetails.Builder}
         * avoiding the need to create one manually via {@link ActionTypeArtifactDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeArtifactDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #outputArtifactDetails(ActionTypeArtifactDetails)}.
         * 
         * @param outputArtifactDetails
         *        a consumer that will call methods on {@link ActionTypeArtifactDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputArtifactDetails(ActionTypeArtifactDetails)
         */
        default Builder outputArtifactDetails(Consumer<ActionTypeArtifactDetails.Builder> outputArtifactDetails) {
            return outputArtifactDetails(ActionTypeArtifactDetails.builder().applyMutation(outputArtifactDetails).build());
        }

        /**
         * <p>
         * Details identifying the accounts with permissions to use the action type.
         * </p>
         * 
         * @param permissions
         *        Details identifying the accounts with permissions to use the action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ActionTypePermissions permissions);

        /**
         * <p>
         * Details identifying the accounts with permissions to use the action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypePermissions.Builder} avoiding
         * the need to create one manually via {@link ActionTypePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypePermissions.Builder#build()} is called immediately and
         * its result is passed to {@link #permissions(ActionTypePermissions)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link ActionTypePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(ActionTypePermissions)
         */
        default Builder permissions(Consumer<ActionTypePermissions.Builder> permissions) {
            return permissions(ActionTypePermissions.builder().applyMutation(permissions).build());
        }

        /**
         * <p>
         * The properties of the action type to be updated.
         * </p>
         * 
         * @param properties
         *        The properties of the action type to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<ActionTypeProperty> properties);

        /**
         * <p>
         * The properties of the action type to be updated.
         * </p>
         * 
         * @param properties
         *        The properties of the action type to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(ActionTypeProperty... properties);

        /**
         * <p>
         * The properties of the action type to be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<ActionTypeProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(java.util.Collection<ActionTypeProperty>)
         */
        Builder properties(Consumer<ActionTypeProperty.Builder>... properties);

        /**
         * <p>
         * The links associated with the action type to be updated.
         * </p>
         * 
         * @param urls
         *        The links associated with the action type to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urls(ActionTypeUrls urls);

        /**
         * <p>
         * The links associated with the action type to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeUrls.Builder} avoiding the need
         * to create one manually via {@link ActionTypeUrls#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeUrls.Builder#build()} is called immediately and its
         * result is passed to {@link #urls(ActionTypeUrls)}.
         * 
         * @param urls
         *        a consumer that will call methods on {@link ActionTypeUrls.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #urls(ActionTypeUrls)
         */
        default Builder urls(Consumer<ActionTypeUrls.Builder> urls) {
            return urls(ActionTypeUrls.builder().applyMutation(urls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private ActionTypeExecutor executor;

        private ActionTypeIdentifier id;

        private ActionTypeArtifactDetails inputArtifactDetails;

        private ActionTypeArtifactDetails outputArtifactDetails;

        private ActionTypePermissions permissions;

        private List<ActionTypeProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private ActionTypeUrls urls;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeDeclaration model) {
            description(model.description);
            executor(model.executor);
            id(model.id);
            inputArtifactDetails(model.inputArtifactDetails);
            outputArtifactDetails(model.outputArtifactDetails);
            permissions(model.permissions);
            properties(model.properties);
            urls(model.urls);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ActionTypeExecutor.Builder getExecutor() {
            return executor != null ? executor.toBuilder() : null;
        }

        public final void setExecutor(ActionTypeExecutor.BuilderImpl executor) {
            this.executor = executor != null ? executor.build() : null;
        }

        @Override
        public final Builder executor(ActionTypeExecutor executor) {
            this.executor = executor;
            return this;
        }

        public final ActionTypeIdentifier.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(ActionTypeIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(ActionTypeIdentifier id) {
            this.id = id;
            return this;
        }

        public final ActionTypeArtifactDetails.Builder getInputArtifactDetails() {
            return inputArtifactDetails != null ? inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ActionTypeArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ActionTypeArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final ActionTypeArtifactDetails.Builder getOutputArtifactDetails() {
            return outputArtifactDetails != null ? outputArtifactDetails.toBuilder() : null;
        }

        public final void setOutputArtifactDetails(ActionTypeArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ActionTypeArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final ActionTypePermissions.Builder getPermissions() {
            return permissions != null ? permissions.toBuilder() : null;
        }

        public final void setPermissions(ActionTypePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(ActionTypePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public final List<ActionTypeProperty.Builder> getProperties() {
            List<ActionTypeProperty.Builder> result = ActionTypePropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<ActionTypeProperty.BuilderImpl> properties) {
            this.properties = ActionTypePropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<ActionTypeProperty> properties) {
            this.properties = ActionTypePropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(ActionTypeProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<ActionTypeProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> ActionTypeProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ActionTypeUrls.Builder getUrls() {
            return urls != null ? urls.toBuilder() : null;
        }

        public final void setUrls(ActionTypeUrls.BuilderImpl urls) {
            this.urls = urls != null ? urls.build() : null;
        }

        @Override
        public final Builder urls(ActionTypeUrls urls) {
            this.urls = urls;
            return this;
        }

        @Override
        public ActionTypeDeclaration build() {
            return new ActionTypeDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
