/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about URLs for web pages that display to customers as links on the pipeline view, such as an
 * external configuration page for the action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeUrls implements SdkPojo, Serializable, ToCopyableBuilder<ActionTypeUrls.Builder, ActionTypeUrls> {
    private static final SdkField<String> CONFIGURATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationUrl").getter(getter(ActionTypeUrls::configurationUrl))
            .setter(setter(Builder::configurationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationUrl").build()).build();

    private static final SdkField<String> ENTITY_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityUrlTemplate").getter(getter(ActionTypeUrls::entityUrlTemplate))
            .setter(setter(Builder::entityUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrlTemplate").build()).build();

    private static final SdkField<String> EXECUTION_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionUrlTemplate").getter(getter(ActionTypeUrls::executionUrlTemplate))
            .setter(setter(Builder::executionUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionUrlTemplate").build())
            .build();

    private static final SdkField<String> REVISION_URL_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionUrlTemplate").getter(getter(ActionTypeUrls::revisionUrlTemplate))
            .setter(setter(Builder::revisionUrlTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrlTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_URL_FIELD,
            ENTITY_URL_TEMPLATE_FIELD, EXECUTION_URL_TEMPLATE_FIELD, REVISION_URL_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationUrl;

    private final String entityUrlTemplate;

    private final String executionUrlTemplate;

    private final String revisionUrlTemplate;

    private ActionTypeUrls(BuilderImpl builder) {
        this.configurationUrl = builder.configurationUrl;
        this.entityUrlTemplate = builder.entityUrlTemplate;
        this.executionUrlTemplate = builder.executionUrlTemplate;
        this.revisionUrlTemplate = builder.revisionUrlTemplate;
    }

    /**
     * <p>
     * The URL returned to the CodePipeline console that contains a link to the page where customers can configure the
     * external action.
     * </p>
     * 
     * @return The URL returned to the CodePipeline console that contains a link to the page where customers can
     *         configure the external action.
     */
    public final String configurationUrl() {
        return configurationUrl;
    }

    /**
     * <p>
     * The URL returned to the CodePipeline console that provides a deep link to the resources of the external system,
     * such as a status page. This link is provided as part of the action display in the pipeline.
     * </p>
     * 
     * @return The URL returned to the CodePipeline console that provides a deep link to the resources of the external
     *         system, such as a status page. This link is provided as part of the action display in the pipeline.
     */
    public final String entityUrlTemplate() {
        return entityUrlTemplate;
    }

    /**
     * <p>
     * The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this link is
     * shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status page.
     * </p>
     * 
     * @return The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this
     *         link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status
     *         page.
     */
    public final String executionUrlTemplate() {
        return executionUrlTemplate;
    }

    /**
     * <p>
     * The URL returned to the CodePipeline console that contains a link to the page where customers can update or
     * change the configuration of the external action.
     * </p>
     * 
     * @return The URL returned to the CodePipeline console that contains a link to the page where customers can update
     *         or change the configuration of the external action.
     */
    public final String revisionUrlTemplate() {
        return revisionUrlTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(entityUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(executionUrlTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrlTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeUrls)) {
            return false;
        }
        ActionTypeUrls other = (ActionTypeUrls) obj;
        return Objects.equals(configurationUrl(), other.configurationUrl())
                && Objects.equals(entityUrlTemplate(), other.entityUrlTemplate())
                && Objects.equals(executionUrlTemplate(), other.executionUrlTemplate())
                && Objects.equals(revisionUrlTemplate(), other.revisionUrlTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeUrls").add("ConfigurationUrl", configurationUrl())
                .add("EntityUrlTemplate", entityUrlTemplate()).add("ExecutionUrlTemplate", executionUrlTemplate())
                .add("RevisionUrlTemplate", revisionUrlTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationUrl":
            return Optional.ofNullable(clazz.cast(configurationUrl()));
        case "entityUrlTemplate":
            return Optional.ofNullable(clazz.cast(entityUrlTemplate()));
        case "executionUrlTemplate":
            return Optional.ofNullable(clazz.cast(executionUrlTemplate()));
        case "revisionUrlTemplate":
            return Optional.ofNullable(clazz.cast(revisionUrlTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurationUrl", CONFIGURATION_URL_FIELD);
        map.put("entityUrlTemplate", ENTITY_URL_TEMPLATE_FIELD);
        map.put("executionUrlTemplate", EXECUTION_URL_TEMPLATE_FIELD);
        map.put("revisionUrlTemplate", REVISION_URL_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeUrls, T> g) {
        return obj -> g.apply((ActionTypeUrls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeUrls> {
        /**
         * <p>
         * The URL returned to the CodePipeline console that contains a link to the page where customers can configure
         * the external action.
         * </p>
         * 
         * @param configurationUrl
         *        The URL returned to the CodePipeline console that contains a link to the page where customers can
         *        configure the external action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationUrl(String configurationUrl);

        /**
         * <p>
         * The URL returned to the CodePipeline console that provides a deep link to the resources of the external
         * system, such as a status page. This link is provided as part of the action display in the pipeline.
         * </p>
         * 
         * @param entityUrlTemplate
         *        The URL returned to the CodePipeline console that provides a deep link to the resources of the
         *        external system, such as a status page. This link is provided as part of the action display in the
         *        pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityUrlTemplate(String entityUrlTemplate);

        /**
         * <p>
         * The link to an execution page for the action type in progress. For example, for a CodeDeploy action, this
         * link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy status
         * page.
         * </p>
         * 
         * @param executionUrlTemplate
         *        The link to an execution page for the action type in progress. For example, for a CodeDeploy action,
         *        this link is shown on the pipeline view page in the CodePipeline console, and it links to a CodeDeploy
         *        status page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionUrlTemplate(String executionUrlTemplate);

        /**
         * <p>
         * The URL returned to the CodePipeline console that contains a link to the page where customers can update or
         * change the configuration of the external action.
         * </p>
         * 
         * @param revisionUrlTemplate
         *        The URL returned to the CodePipeline console that contains a link to the page where customers can
         *        update or change the configuration of the external action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrlTemplate(String revisionUrlTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String configurationUrl;

        private String entityUrlTemplate;

        private String executionUrlTemplate;

        private String revisionUrlTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeUrls model) {
            configurationUrl(model.configurationUrl);
            entityUrlTemplate(model.entityUrlTemplate);
            executionUrlTemplate(model.executionUrlTemplate);
            revisionUrlTemplate(model.revisionUrlTemplate);
        }

        public final String getConfigurationUrl() {
            return configurationUrl;
        }

        public final void setConfigurationUrl(String configurationUrl) {
            this.configurationUrl = configurationUrl;
        }

        @Override
        public final Builder configurationUrl(String configurationUrl) {
            this.configurationUrl = configurationUrl;
            return this;
        }

        public final String getEntityUrlTemplate() {
            return entityUrlTemplate;
        }

        public final void setEntityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
        }

        @Override
        public final Builder entityUrlTemplate(String entityUrlTemplate) {
            this.entityUrlTemplate = entityUrlTemplate;
            return this;
        }

        public final String getExecutionUrlTemplate() {
            return executionUrlTemplate;
        }

        public final void setExecutionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
        }

        @Override
        public final Builder executionUrlTemplate(String executionUrlTemplate) {
            this.executionUrlTemplate = executionUrlTemplate;
            return this;
        }

        public final String getRevisionUrlTemplate() {
            return revisionUrlTemplate;
        }

        public final void setRevisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
        }

        @Override
        public final Builder revisionUrlTemplate(String revisionUrlTemplate) {
            this.revisionUrlTemplate = revisionUrlTemplate;
            return this;
        }

        @Override
        public ActionTypeUrls build() {
            return new ActionTypeUrls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
