/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the details of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobDetails.Builder, JobDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(JobDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<JobData> DATA_FIELD = SdkField.<JobData> builder(MarshallingType.SDK_POJO).memberName("data")
            .getter(getter(JobDetails::data)).setter(setter(Builder::data)).constructor(JobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(JobDetails::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD,
            ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final JobData data;

    private final String accountId;

    private JobDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.accountId = builder.accountId;
    }

    /**
     * <p>
     * The unique system-generated ID of the job.
     * </p>
     * 
     * @return The unique system-generated ID of the job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Represents other information about a job required for a job worker to complete the job.
     * </p>
     * 
     * @return Represents other information about a job required for a job worker to complete the job.
     */
    public final JobData data() {
        return data;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the job.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the job.
     */
    public final String accountId() {
        return accountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(data(), other.data())
                && Objects.equals(accountId(), other.accountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDetails").add("Id", id()).add("Data", data()).add("AccountId", accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("data", DATA_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDetails> {
        /**
         * <p>
         * The unique system-generated ID of the job.
         * </p>
         * 
         * @param id
         *        The unique system-generated ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Represents other information about a job required for a job worker to complete the job.
         * </p>
         * 
         * @param data
         *        Represents other information about a job required for a job worker to complete the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(JobData data);

        /**
         * <p>
         * Represents other information about a job required for a job worker to complete the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobData.Builder} avoiding the need to
         * create one manually via {@link JobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobData.Builder#build()} is called immediately and its result is
         * passed to {@link #data(JobData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link JobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(JobData)
         */
        default Builder data(Consumer<JobData.Builder> data) {
            return data(JobData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The Amazon Web Services account ID associated with the job.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private JobData data;

        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            id(model.id);
            data(model.data);
            accountId(model.accountId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final JobData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public JobDetails build() {
            return new JobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
