/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field that specifies to filter on the latest execution in the pipeline.
 * </p>
 * <note>
 * <p>
 * Filtering on the latest execution is available for executions run on or after February 08, 2024.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LatestInPipelineExecutionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<LatestInPipelineExecutionFilter.Builder, LatestInPipelineExecutionFilter> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(LatestInPipelineExecutionFilter::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> START_TIME_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTimeRange").getter(getter(LatestInPipelineExecutionFilter::startTimeRangeAsString))
            .setter(setter(Builder::startTimeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD,
            START_TIME_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionId;

    private final String startTimeRange;

    private LatestInPipelineExecutionFilter(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.startTimeRange = builder.startTimeRange;
    }

    /**
     * <p>
     * The execution ID for the latest execution in the pipeline.
     * </p>
     * 
     * @return The execution ID for the latest execution in the pipeline.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The start time to filter on for the latest execution in the pipeline. Valid options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All
     * </p>
     * </li>
     * <li>
     * <p>
     * Latest
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startTimeRange}
     * will return {@link StartTimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startTimeRangeAsString}.
     * </p>
     * 
     * @return The start time to filter on for the latest execution in the pipeline. Valid options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         All
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latest
     *         </p>
     *         </li>
     * @see StartTimeRange
     */
    public final StartTimeRange startTimeRange() {
        return StartTimeRange.fromValue(startTimeRange);
    }

    /**
     * <p>
     * The start time to filter on for the latest execution in the pipeline. Valid options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All
     * </p>
     * </li>
     * <li>
     * <p>
     * Latest
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startTimeRange}
     * will return {@link StartTimeRange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startTimeRangeAsString}.
     * </p>
     * 
     * @return The start time to filter on for the latest execution in the pipeline. Valid options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         All
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Latest
     *         </p>
     *         </li>
     * @see StartTimeRange
     */
    public final String startTimeRangeAsString() {
        return startTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeRangeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestInPipelineExecutionFilter)) {
            return false;
        }
        LatestInPipelineExecutionFilter other = (LatestInPipelineExecutionFilter) obj;
        return Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(startTimeRangeAsString(), other.startTimeRangeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LatestInPipelineExecutionFilter").add("PipelineExecutionId", pipelineExecutionId())
                .add("StartTimeRange", startTimeRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "startTimeRange":
            return Optional.ofNullable(clazz.cast(startTimeRangeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        map.put("startTimeRange", START_TIME_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LatestInPipelineExecutionFilter, T> g) {
        return obj -> g.apply((LatestInPipelineExecutionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LatestInPipelineExecutionFilter> {
        /**
         * <p>
         * The execution ID for the latest execution in the pipeline.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The execution ID for the latest execution in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The start time to filter on for the latest execution in the pipeline. Valid options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All
         * </p>
         * </li>
         * <li>
         * <p>
         * Latest
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTimeRange
         *        The start time to filter on for the latest execution in the pipeline. Valid options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latest
         *        </p>
         *        </li>
         * @see StartTimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartTimeRange
         */
        Builder startTimeRange(String startTimeRange);

        /**
         * <p>
         * The start time to filter on for the latest execution in the pipeline. Valid options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All
         * </p>
         * </li>
         * <li>
         * <p>
         * Latest
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTimeRange
         *        The start time to filter on for the latest execution in the pipeline. Valid options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Latest
         *        </p>
         *        </li>
         * @see StartTimeRange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartTimeRange
         */
        Builder startTimeRange(StartTimeRange startTimeRange);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionId;

        private String startTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestInPipelineExecutionFilter model) {
            pipelineExecutionId(model.pipelineExecutionId);
            startTimeRange(model.startTimeRange);
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getStartTimeRange() {
            return startTimeRange;
        }

        public final void setStartTimeRange(String startTimeRange) {
            this.startTimeRange = startTimeRange;
        }

        @Override
        public final Builder startTimeRange(String startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        @Override
        public final Builder startTimeRange(StartTimeRange startTimeRange) {
            this.startTimeRange(startTimeRange == null ? null : startTimeRange.toString());
            return this;
        }

        @Override
        public LatestInPipelineExecutionFilter build() {
            return new LatestInPipelineExecutionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
