/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleExecutionsRequest extends CodePipelineRequest implements
        ToCopyableBuilder<ListRuleExecutionsRequest.Builder, ListRuleExecutionsRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(ListRuleExecutionsRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<RuleExecutionFilter> FILTER_FIELD = SdkField
            .<RuleExecutionFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListRuleExecutionsRequest::filter)).setter(setter(Builder::filter))
            .constructor(RuleExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRuleExecutionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRuleExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineName;

    private final RuleExecutionFilter filter;

    private final Integer maxResults;

    private final String nextToken;

    private ListRuleExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the pipeline for which you want to get execution summary information.
     * </p>
     * 
     * @return The name of the pipeline for which you want to get execution summary information.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * Input information used to filter rule execution history.
     * </p>
     * 
     * @return Input information used to filter rule execution history.
     */
    public final RuleExecutionFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline
     * execution start times. Default value is 100.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based
     *         on pipeline execution start times. Default value is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token that was returned from the previous <code>ListRuleExecutions</code> call, which can be used to return
     * the next set of rule executions in the list.
     * </p>
     * 
     * @return The token that was returned from the previous <code>ListRuleExecutions</code> call, which can be used to
     *         return the next set of rule executions in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleExecutionsRequest)) {
            return false;
        }
        ListRuleExecutionsRequest other = (ListRuleExecutionsRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(filter(), other.filter())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRuleExecutionsRequest").add("PipelineName", pipelineName()).add("Filter", filter())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRuleExecutionsRequest, T> g) {
        return obj -> g.apply((ListRuleExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRuleExecutionsRequest> {
        /**
         * <p>
         * The name of the pipeline for which you want to get execution summary information.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline for which you want to get execution summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * Input information used to filter rule execution history.
         * </p>
         * 
         * @param filter
         *        Input information used to filter rule execution history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(RuleExecutionFilter filter);

        /**
         * <p>
         * Input information used to filter rule execution history.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleExecutionFilter.Builder} avoiding the
         * need to create one manually via {@link RuleExecutionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleExecutionFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filter(RuleExecutionFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link RuleExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(RuleExecutionFilter)
         */
        default Builder filter(Consumer<RuleExecutionFilter.Builder> filter) {
            return filter(RuleExecutionFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on
         * pipeline execution start times. Default value is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned nextToken value. Pipeline history is limited to the most recent 12
         *        months, based on pipeline execution start times. Default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token that was returned from the previous <code>ListRuleExecutions</code> call, which can be used to
         * return the next set of rule executions in the list.
         * </p>
         * 
         * @param nextToken
         *        The token that was returned from the previous <code>ListRuleExecutions</code> call, which can be used
         *        to return the next set of rule executions in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private RuleExecutionFilter filter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleExecutionsRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final RuleExecutionFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(RuleExecutionFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(RuleExecutionFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRuleExecutionsRequest build() {
            return new ListRuleExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
