/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutThirdPartyJobSuccessResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutThirdPartyJobSuccessResultRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutThirdPartyJobSuccessResultRequest.Builder, PutThirdPartyJobSuccessResultRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(PutThirdPartyJobSuccessResultRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(PutThirdPartyJobSuccessResultRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<CurrentRevision> CURRENT_REVISION_FIELD = SdkField
            .<CurrentRevision> builder(MarshallingType.SDK_POJO).memberName("currentRevision")
            .getter(getter(PutThirdPartyJobSuccessResultRequest::currentRevision)).setter(setter(Builder::currentRevision))
            .constructor(CurrentRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(PutThirdPartyJobSuccessResultRequest::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("executionDetails")
            .getter(getter(PutThirdPartyJobSuccessResultRequest::executionDetails)).setter(setter(Builder::executionDetails))
            .constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            CLIENT_TOKEN_FIELD, CURRENT_REVISION_FIELD, CONTINUATION_TOKEN_FIELD, EXECUTION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String clientToken;

    private final CurrentRevision currentRevision;

    private final String continuationToken;

    private final ExecutionDetails executionDetails;

    private PutThirdPartyJobSuccessResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.clientToken = builder.clientToken;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
    }

    /**
     * <p>
     * The ID of the job that successfully completed. This is the same ID returned from
     * <code>PollForThirdPartyJobs</code>.
     * </p>
     * 
     * @return The ID of the job that successfully completed. This is the same ID returned from
     *         <code>PollForThirdPartyJobs</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed
     * access to the job and its details.
     * </p>
     * 
     * @return The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
     *         allowed access to the job and its details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Represents information about a current revision.
     * </p>
     * 
     * @return Represents information about a current revision.
     */
    public final CurrentRevision currentRevision() {
        return currentRevision;
    }

    /**
     * <p>
     * A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to identify
     * a partner action in progress. Future jobs use this token to identify the running instance of the action. It can
     * be reused to return more information about the progress of the partner action. When the action is complete, no
     * continuation token should be supplied.
     * </p>
     * 
     * @return A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to
     *         identify a partner action in progress. Future jobs use this token to identify the running instance of the
     *         action. It can be reused to return more information about the progress of the partner action. When the
     *         action is complete, no continuation token should be supplied.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline.
     * </p>
     * 
     * @return The details of the actions taken and results produced on an artifact as it passes through stages in the
     *         pipeline.
     */
    public final ExecutionDetails executionDetails() {
        return executionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutThirdPartyJobSuccessResultRequest)) {
            return false;
        }
        PutThirdPartyJobSuccessResultRequest other = (PutThirdPartyJobSuccessResultRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(currentRevision(), other.currentRevision())
                && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(executionDetails(), other.executionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutThirdPartyJobSuccessResultRequest").add("JobId", jobId()).add("ClientToken", clientToken())
                .add("CurrentRevision", currentRevision()).add("ContinuationToken", continuationToken())
                .add("ExecutionDetails", executionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "currentRevision":
            return Optional.ofNullable(clazz.cast(currentRevision()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "executionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("currentRevision", CURRENT_REVISION_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutThirdPartyJobSuccessResultRequest, T> g) {
        return obj -> g.apply((PutThirdPartyJobSuccessResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutThirdPartyJobSuccessResultRequest> {
        /**
         * <p>
         * The ID of the job that successfully completed. This is the same ID returned from
         * <code>PollForThirdPartyJobs</code>.
         * </p>
         * 
         * @param jobId
         *        The ID of the job that successfully completed. This is the same ID returned from
         *        <code>PollForThirdPartyJobs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
         * allowed access to the job and its details.
         * </p>
         * 
         * @param clientToken
         *        The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
         *        allowed access to the job and its details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Represents information about a current revision.
         * </p>
         * 
         * @param currentRevision
         *        Represents information about a current revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevision(CurrentRevision currentRevision);

        /**
         * <p>
         * Represents information about a current revision.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentRevision.Builder} avoiding the
         * need to create one manually via {@link CurrentRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrentRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #currentRevision(CurrentRevision)}.
         * 
         * @param currentRevision
         *        a consumer that will call methods on {@link CurrentRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRevision(CurrentRevision)
         */
        default Builder currentRevision(Consumer<CurrentRevision.Builder> currentRevision) {
            return currentRevision(CurrentRevision.builder().applyMutation(currentRevision).build());
        }

        /**
         * <p>
         * A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to
         * identify a partner action in progress. Future jobs use this token to identify the running instance of the
         * action. It can be reused to return more information about the progress of the partner action. When the action
         * is complete, no continuation token should be supplied.
         * </p>
         * 
         * @param continuationToken
         *        A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides
         *        to identify a partner action in progress. Future jobs use this token to identify the running instance
         *        of the action. It can be reused to return more information about the progress of the partner action.
         *        When the action is complete, no continuation token should be supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * The details of the actions taken and results produced on an artifact as it passes through stages in the
         * pipeline.
         * </p>
         * 
         * @param executionDetails
         *        The details of the actions taken and results produced on an artifact as it passes through stages in
         *        the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(ExecutionDetails executionDetails);

        /**
         * <p>
         * The details of the actions taken and results produced on an artifact as it passes through stages in the
         * pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionDetails.Builder} avoiding the
         * need to create one manually via {@link ExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #executionDetails(ExecutionDetails)}.
         * 
         * @param executionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionDetails(ExecutionDetails)
         */
        default Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return executionDetails(ExecutionDetails.builder().applyMutation(executionDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String jobId;

        private String clientToken;

        private CurrentRevision currentRevision;

        private String continuationToken;

        private ExecutionDetails executionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutThirdPartyJobSuccessResultRequest model) {
            super(model);
            jobId(model.jobId);
            clientToken(model.clientToken);
            currentRevision(model.currentRevision);
            continuationToken(model.continuationToken);
            executionDetails(model.executionDetails);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return currentRevision != null ? currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return executionDetails != null ? executionDetails.toBuilder() : null;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutThirdPartyJobSuccessResultRequest build() {
            return new PutThirdPartyJobSuccessResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
