/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output details listed for a rule execution, such as the rule execution result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleExecutionOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleExecutionOutput.Builder, RuleExecutionOutput> {
    private static final SdkField<RuleExecutionResult> EXECUTION_RESULT_FIELD = SdkField
            .<RuleExecutionResult> builder(MarshallingType.SDK_POJO).memberName("executionResult")
            .getter(getter(RuleExecutionOutput::executionResult)).setter(setter(Builder::executionResult))
            .constructor(RuleExecutionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RuleExecutionResult executionResult;

    private RuleExecutionOutput(BuilderImpl builder) {
        this.executionResult = builder.executionResult;
    }

    /**
     * <p>
     * Execution result information listed in the output details for a rule execution.
     * </p>
     * 
     * @return Execution result information listed in the output details for a rule execution.
     */
    public final RuleExecutionResult executionResult() {
        return executionResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecutionOutput)) {
            return false;
        }
        RuleExecutionOutput other = (RuleExecutionOutput) obj;
        return Objects.equals(executionResult(), other.executionResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleExecutionOutput").add("ExecutionResult", executionResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionResult":
            return Optional.ofNullable(clazz.cast(executionResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionResult", EXECUTION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleExecutionOutput, T> g) {
        return obj -> g.apply((RuleExecutionOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleExecutionOutput> {
        /**
         * <p>
         * Execution result information listed in the output details for a rule execution.
         * </p>
         * 
         * @param executionResult
         *        Execution result information listed in the output details for a rule execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionResult(RuleExecutionResult executionResult);

        /**
         * <p>
         * Execution result information listed in the output details for a rule execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleExecutionResult.Builder} avoiding the
         * need to create one manually via {@link RuleExecutionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleExecutionResult.Builder#build()} is called immediately and
         * its result is passed to {@link #executionResult(RuleExecutionResult)}.
         * 
         * @param executionResult
         *        a consumer that will call methods on {@link RuleExecutionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionResult(RuleExecutionResult)
         */
        default Builder executionResult(Consumer<RuleExecutionResult.Builder> executionResult) {
            return executionResult(RuleExecutionResult.builder().applyMutation(executionResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RuleExecutionResult executionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleExecutionOutput model) {
            executionResult(model.executionResult);
        }

        public final RuleExecutionResult.Builder getExecutionResult() {
            return executionResult != null ? executionResult.toBuilder() : null;
        }

        public final void setExecutionResult(RuleExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        @Override
        public final Builder executionResult(RuleExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        @Override
        public RuleExecutionOutput build() {
            return new RuleExecutionOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
