/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the state of a rule.
 * </p>
 * <note>
 * <p>
 * Values returned in the <code>revisionId</code> field indicate the rule revision information, such as the commit ID,
 * for the current state.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleState implements SdkPojo, Serializable, ToCopyableBuilder<RuleState.Builder, RuleState> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(RuleState::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<RuleRevision> CURRENT_REVISION_FIELD = SdkField
            .<RuleRevision> builder(MarshallingType.SDK_POJO).memberName("currentRevision")
            .getter(getter(RuleState::currentRevision)).setter(setter(Builder::currentRevision))
            .constructor(RuleRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()).build();

    private static final SdkField<RuleExecution> LATEST_EXECUTION_FIELD = SdkField
            .<RuleExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(RuleState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(RuleExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final SdkField<String> ENTITY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityUrl").getter(getter(RuleState::entityUrl)).setter(setter(Builder::entityUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityUrl").build()).build();

    private static final SdkField<String> REVISION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionUrl").getter(getter(RuleState::revisionUrl)).setter(setter(Builder::revisionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            CURRENT_REVISION_FIELD, LATEST_EXECUTION_FIELD, ENTITY_URL_FIELD, REVISION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final RuleRevision currentRevision;

    private final RuleExecution latestExecution;

    private final String entityUrl;

    private final String revisionUrl;

    private RuleState(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.currentRevision = builder.currentRevision;
        this.latestExecution = builder.latestExecution;
        this.entityUrl = builder.entityUrl;
        this.revisionUrl = builder.revisionUrl;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The ID of the current revision of the artifact successfully worked on by the job.
     * </p>
     * 
     * @return The ID of the current revision of the artifact successfully worked on by the job.
     */
    public final RuleRevision currentRevision() {
        return currentRevision;
    }

    /**
     * <p>
     * Represents information about the latest run of an rule.
     * </p>
     * 
     * @return Represents information about the latest run of an rule.
     */
    public final RuleExecution latestExecution() {
        return latestExecution;
    }

    /**
     * <p>
     * A URL link for more information about the state of the action, such as a details page.
     * </p>
     * 
     * @return A URL link for more information about the state of the action, such as a details page.
     */
    public final String entityUrl() {
        return entityUrl;
    }

    /**
     * <p>
     * A URL link for more information about the revision, such as a commit details page.
     * </p>
     * 
     * @return A URL link for more information about the revision, such as a commit details page.
     */
    public final String revisionUrl() {
        return revisionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(entityUrl());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleState)) {
            return false;
        }
        RuleState other = (RuleState) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(currentRevision(), other.currentRevision())
                && Objects.equals(latestExecution(), other.latestExecution()) && Objects.equals(entityUrl(), other.entityUrl())
                && Objects.equals(revisionUrl(), other.revisionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleState").add("RuleName", ruleName()).add("CurrentRevision", currentRevision())
                .add("LatestExecution", latestExecution()).add("EntityUrl", entityUrl()).add("RevisionUrl", revisionUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "currentRevision":
            return Optional.ofNullable(clazz.cast(currentRevision()));
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        case "entityUrl":
            return Optional.ofNullable(clazz.cast(entityUrl()));
        case "revisionUrl":
            return Optional.ofNullable(clazz.cast(revisionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("currentRevision", CURRENT_REVISION_FIELD);
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("entityUrl", ENTITY_URL_FIELD);
        map.put("revisionUrl", REVISION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleState, T> g) {
        return obj -> g.apply((RuleState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleState> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * 
         * @param currentRevision
         *        The ID of the current revision of the artifact successfully worked on by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevision(RuleRevision currentRevision);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleRevision.Builder} avoiding the need
         * to create one manually via {@link RuleRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #currentRevision(RuleRevision)}.
         * 
         * @param currentRevision
         *        a consumer that will call methods on {@link RuleRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRevision(RuleRevision)
         */
        default Builder currentRevision(Consumer<RuleRevision.Builder> currentRevision) {
            return currentRevision(RuleRevision.builder().applyMutation(currentRevision).build());
        }

        /**
         * <p>
         * Represents information about the latest run of an rule.
         * </p>
         * 
         * @param latestExecution
         *        Represents information about the latest run of an rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(RuleExecution latestExecution);

        /**
         * <p>
         * Represents information about the latest run of an rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleExecution.Builder} avoiding the need
         * to create one manually via {@link RuleExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #latestExecution(RuleExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link RuleExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(RuleExecution)
         */
        default Builder latestExecution(Consumer<RuleExecution.Builder> latestExecution) {
            return latestExecution(RuleExecution.builder().applyMutation(latestExecution).build());
        }

        /**
         * <p>
         * A URL link for more information about the state of the action, such as a details page.
         * </p>
         * 
         * @param entityUrl
         *        A URL link for more information about the state of the action, such as a details page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityUrl(String entityUrl);

        /**
         * <p>
         * A URL link for more information about the revision, such as a commit details page.
         * </p>
         * 
         * @param revisionUrl
         *        A URL link for more information about the revision, such as a commit details page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrl(String revisionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private RuleRevision currentRevision;

        private RuleExecution latestExecution;

        private String entityUrl;

        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleState model) {
            ruleName(model.ruleName);
            currentRevision(model.currentRevision);
            latestExecution(model.latestExecution);
            entityUrl(model.entityUrl);
            revisionUrl(model.revisionUrl);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final RuleRevision.Builder getCurrentRevision() {
            return currentRevision != null ? currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(RuleRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(RuleRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final RuleExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(RuleExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(RuleExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final String getEntityUrl() {
            return entityUrl;
        }

        public final void setEntityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
        }

        @Override
        public final Builder entityUrl(String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        public final String getRevisionUrl() {
            return revisionUrl;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        @Override
        public RuleState build() {
            return new RuleState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
