/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a stage and its definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<StageDeclaration.Builder, StageDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StageDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<BlockerDeclaration>> BLOCKERS_FIELD = SdkField
            .<List<BlockerDeclaration>> builder(MarshallingType.LIST)
            .memberName("blockers")
            .getter(getter(StageDeclaration::blockers))
            .setter(setter(Builder::blockers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockerDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockerDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ActionDeclaration>> ACTIONS_FIELD = SdkField
            .<List<ActionDeclaration>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(StageDeclaration::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FailureConditions> ON_FAILURE_FIELD = SdkField
            .<FailureConditions> builder(MarshallingType.SDK_POJO).memberName("onFailure")
            .getter(getter(StageDeclaration::onFailure)).setter(setter(Builder::onFailure))
            .constructor(FailureConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailure").build()).build();

    private static final SdkField<SuccessConditions> ON_SUCCESS_FIELD = SdkField
            .<SuccessConditions> builder(MarshallingType.SDK_POJO).memberName("onSuccess")
            .getter(getter(StageDeclaration::onSuccess)).setter(setter(Builder::onSuccess))
            .constructor(SuccessConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onSuccess").build()).build();

    private static final SdkField<BeforeEntryConditions> BEFORE_ENTRY_FIELD = SdkField
            .<BeforeEntryConditions> builder(MarshallingType.SDK_POJO).memberName("beforeEntry")
            .getter(getter(StageDeclaration::beforeEntry)).setter(setter(Builder::beforeEntry))
            .constructor(BeforeEntryConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCKERS_FIELD,
            ACTIONS_FIELD, ON_FAILURE_FIELD, ON_SUCCESS_FIELD, BEFORE_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<BlockerDeclaration> blockers;

    private final List<ActionDeclaration> actions;

    private final FailureConditions onFailure;

    private final SuccessConditions onSuccess;

    private final BeforeEntryConditions beforeEntry;

    private StageDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.blockers = builder.blockers;
        this.actions = builder.actions;
        this.onFailure = builder.onFailure;
        this.onSuccess = builder.onSuccess;
        this.beforeEntry = builder.beforeEntry;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Blockers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlockers() {
        return blockers != null && !(blockers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockers} method.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final List<BlockerDeclaration> blockers() {
        return blockers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions included in a stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions included in a stage.
     */
    public final List<ActionDeclaration> actions() {
        return actions;
    }

    /**
     * <p>
     * The method to use when a stage has not completed successfully. For example, configuring this field for rollback
     * will roll back a failed stage automatically to the last successful pipeline execution in the stage.
     * </p>
     * 
     * @return The method to use when a stage has not completed successfully. For example, configuring this field for
     *         rollback will roll back a failed stage automatically to the last successful pipeline execution in the
     *         stage.
     */
    public final FailureConditions onFailure() {
        return onFailure;
    }

    /**
     * <p>
     * The method to use when a stage has succeeded. For example, configuring this field for conditions will allow the
     * stage to succeed when the conditions are met.
     * </p>
     * 
     * @return The method to use when a stage has succeeded. For example, configuring this field for conditions will
     *         allow the stage to succeed when the conditions are met.
     */
    public final SuccessConditions onSuccess() {
        return onSuccess;
    }

    /**
     * <p>
     * The method to use when a stage allows entry. For example, configuring this field for conditions will allow entry
     * to the stage when the conditions are met.
     * </p>
     * 
     * @return The method to use when a stage allows entry. For example, configuring this field for conditions will
     *         allow entry to the stage when the conditions are met.
     */
    public final BeforeEntryConditions beforeEntry() {
        return beforeEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockers() ? blockers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(onFailure());
        hashCode = 31 * hashCode + Objects.hashCode(onSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(beforeEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration) obj;
        return Objects.equals(name(), other.name()) && hasBlockers() == other.hasBlockers()
                && Objects.equals(blockers(), other.blockers()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && Objects.equals(onFailure(), other.onFailure())
                && Objects.equals(onSuccess(), other.onSuccess()) && Objects.equals(beforeEntry(), other.beforeEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageDeclaration").add("Name", name()).add("Blockers", hasBlockers() ? blockers() : null)
                .add("Actions", hasActions() ? actions() : null).add("OnFailure", onFailure()).add("OnSuccess", onSuccess())
                .add("BeforeEntry", beforeEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "blockers":
            return Optional.ofNullable(clazz.cast(blockers()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "onFailure":
            return Optional.ofNullable(clazz.cast(onFailure()));
        case "onSuccess":
            return Optional.ofNullable(clazz.cast(onSuccess()));
        case "beforeEntry":
            return Optional.ofNullable(clazz.cast(beforeEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("blockers", BLOCKERS_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("onFailure", ON_FAILURE_FIELD);
        map.put("onSuccess", ON_SUCCESS_FIELD);
        map.put("beforeEntry", BEFORE_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StageDeclaration, T> g) {
        return obj -> g.apply((StageDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageDeclaration> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param name
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param blockers
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockers(Collection<BlockerDeclaration> blockers);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param blockers
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockers(BlockerDeclaration... blockers);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #blockers(List<BlockerDeclaration>)}.
         * 
         * @param blockers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockers(java.util.Collection<BlockerDeclaration>)
         */
        Builder blockers(Consumer<BlockerDeclaration.Builder>... blockers);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * 
         * @param actions
         *        The actions included in a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<ActionDeclaration> actions);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * 
         * @param actions
         *        The actions included in a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ActionDeclaration... actions);

        /**
         * <p>
         * The actions included in a stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionDeclaration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<ActionDeclaration>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<ActionDeclaration>)
         */
        Builder actions(Consumer<ActionDeclaration.Builder>... actions);

        /**
         * <p>
         * The method to use when a stage has not completed successfully. For example, configuring this field for
         * rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
         * </p>
         * 
         * @param onFailure
         *        The method to use when a stage has not completed successfully. For example, configuring this field for
         *        rollback will roll back a failed stage automatically to the last successful pipeline execution in the
         *        stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onFailure(FailureConditions onFailure);

        /**
         * <p>
         * The method to use when a stage has not completed successfully. For example, configuring this field for
         * rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureConditions.Builder} avoiding the
         * need to create one manually via {@link FailureConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureConditions.Builder#build()} is called immediately and its
         * result is passed to {@link #onFailure(FailureConditions)}.
         * 
         * @param onFailure
         *        a consumer that will call methods on {@link FailureConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onFailure(FailureConditions)
         */
        default Builder onFailure(Consumer<FailureConditions.Builder> onFailure) {
            return onFailure(FailureConditions.builder().applyMutation(onFailure).build());
        }

        /**
         * <p>
         * The method to use when a stage has succeeded. For example, configuring this field for conditions will allow
         * the stage to succeed when the conditions are met.
         * </p>
         * 
         * @param onSuccess
         *        The method to use when a stage has succeeded. For example, configuring this field for conditions will
         *        allow the stage to succeed when the conditions are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onSuccess(SuccessConditions onSuccess);

        /**
         * <p>
         * The method to use when a stage has succeeded. For example, configuring this field for conditions will allow
         * the stage to succeed when the conditions are met.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuccessConditions.Builder} avoiding the
         * need to create one manually via {@link SuccessConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuccessConditions.Builder#build()} is called immediately and its
         * result is passed to {@link #onSuccess(SuccessConditions)}.
         * 
         * @param onSuccess
         *        a consumer that will call methods on {@link SuccessConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onSuccess(SuccessConditions)
         */
        default Builder onSuccess(Consumer<SuccessConditions.Builder> onSuccess) {
            return onSuccess(SuccessConditions.builder().applyMutation(onSuccess).build());
        }

        /**
         * <p>
         * The method to use when a stage allows entry. For example, configuring this field for conditions will allow
         * entry to the stage when the conditions are met.
         * </p>
         * 
         * @param beforeEntry
         *        The method to use when a stage allows entry. For example, configuring this field for conditions will
         *        allow entry to the stage when the conditions are met.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeEntry(BeforeEntryConditions beforeEntry);

        /**
         * <p>
         * The method to use when a stage allows entry. For example, configuring this field for conditions will allow
         * entry to the stage when the conditions are met.
         * </p>
         * This is a convenience method that creates an instance of the {@link BeforeEntryConditions.Builder} avoiding
         * the need to create one manually via {@link BeforeEntryConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BeforeEntryConditions.Builder#build()} is called immediately and
         * its result is passed to {@link #beforeEntry(BeforeEntryConditions)}.
         * 
         * @param beforeEntry
         *        a consumer that will call methods on {@link BeforeEntryConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeEntry(BeforeEntryConditions)
         */
        default Builder beforeEntry(Consumer<BeforeEntryConditions.Builder> beforeEntry) {
            return beforeEntry(BeforeEntryConditions.builder().applyMutation(beforeEntry).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<BlockerDeclaration> blockers = DefaultSdkAutoConstructList.getInstance();

        private List<ActionDeclaration> actions = DefaultSdkAutoConstructList.getInstance();

        private FailureConditions onFailure;

        private SuccessConditions onSuccess;

        private BeforeEntryConditions beforeEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeclaration model) {
            name(model.name);
            blockers(model.blockers);
            actions(model.actions);
            onFailure(model.onFailure);
            onSuccess(model.onSuccess);
            beforeEntry(model.beforeEntry);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<BlockerDeclaration.Builder> getBlockers() {
            List<BlockerDeclaration.Builder> result = StageBlockerDeclarationListCopier.copyToBuilder(this.blockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockers(Collection<BlockerDeclaration.BuilderImpl> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copyFromBuilder(blockers);
        }

        @Override
        public final Builder blockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(BlockerDeclaration... blockers) {
            blockers(Arrays.asList(blockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(Consumer<BlockerDeclaration.Builder>... blockers) {
            blockers(Stream.of(blockers).map(c -> BlockerDeclaration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDeclaration.Builder> getActions() {
            List<ActionDeclaration.Builder> result = StageActionDeclarationListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ActionDeclaration.BuilderImpl> actions) {
            this.actions = StageActionDeclarationListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionDeclaration... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionDeclaration.Builder>... actions) {
            actions(Stream.of(actions).map(c -> ActionDeclaration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final FailureConditions.Builder getOnFailure() {
            return onFailure != null ? onFailure.toBuilder() : null;
        }

        public final void setOnFailure(FailureConditions.BuilderImpl onFailure) {
            this.onFailure = onFailure != null ? onFailure.build() : null;
        }

        @Override
        public final Builder onFailure(FailureConditions onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public final SuccessConditions.Builder getOnSuccess() {
            return onSuccess != null ? onSuccess.toBuilder() : null;
        }

        public final void setOnSuccess(SuccessConditions.BuilderImpl onSuccess) {
            this.onSuccess = onSuccess != null ? onSuccess.build() : null;
        }

        @Override
        public final Builder onSuccess(SuccessConditions onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        public final BeforeEntryConditions.Builder getBeforeEntry() {
            return beforeEntry != null ? beforeEntry.toBuilder() : null;
        }

        public final void setBeforeEntry(BeforeEntryConditions.BuilderImpl beforeEntry) {
            this.beforeEntry = beforeEntry != null ? beforeEntry.build() : null;
        }

        @Override
        public final Builder beforeEntry(BeforeEntryConditions beforeEntry) {
            this.beforeEntry = beforeEntry;
            return this;
        }

        @Override
        public StageDeclaration build() {
            return new StageDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
