/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event criteria that specify when a specified repository event will start the pipeline for the specified trigger
 * configuration, such as the lists of Git tags to include and exclude.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitPushFilter implements SdkPojo, Serializable, ToCopyableBuilder<GitPushFilter.Builder, GitPushFilter> {
    private static final SdkField<GitTagFilterCriteria> TAGS_FIELD = SdkField
            .<GitTagFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("tags").getter(getter(GitPushFilter::tags))
            .setter(setter(Builder::tags)).constructor(GitTagFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()).build();

    private static final SdkField<GitBranchFilterCriteria> BRANCHES_FIELD = SdkField
            .<GitBranchFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("branches")
            .getter(getter(GitPushFilter::branches)).setter(setter(Builder::branches))
            .constructor(GitBranchFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build()).build();

    private static final SdkField<GitFilePathFilterCriteria> FILE_PATHS_FIELD = SdkField
            .<GitFilePathFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filePaths")
            .getter(getter(GitPushFilter::filePaths)).setter(setter(Builder::filePaths))
            .constructor(GitFilePathFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, BRANCHES_FIELD,
            FILE_PATHS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GitTagFilterCriteria tags;

    private final GitBranchFilterCriteria branches;

    private final GitFilePathFilterCriteria filePaths;

    private GitPushFilter(BuilderImpl builder) {
        this.tags = builder.tags;
        this.branches = builder.branches;
        this.filePaths = builder.filePaths;
    }

    /**
     * <p>
     * The field that contains the details for the Git tags trigger configuration.
     * </p>
     * 
     * @return The field that contains the details for the Git tags trigger configuration.
     */
    public final GitTagFilterCriteria tags() {
        return tags;
    }

    /**
     * <p>
     * The field that specifies to filter on branches for the push trigger configuration.
     * </p>
     * 
     * @return The field that specifies to filter on branches for the push trigger configuration.
     */
    public final GitBranchFilterCriteria branches() {
        return branches;
    }

    /**
     * <p>
     * The field that specifies to filter on file paths for the push trigger configuration.
     * </p>
     * 
     * @return The field that specifies to filter on file paths for the push trigger configuration.
     */
    public final GitFilePathFilterCriteria filePaths() {
        return filePaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(branches());
        hashCode = 31 * hashCode + Objects.hashCode(filePaths());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPushFilter)) {
            return false;
        }
        GitPushFilter other = (GitPushFilter) obj;
        return Objects.equals(tags(), other.tags()) && Objects.equals(branches(), other.branches())
                && Objects.equals(filePaths(), other.filePaths());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitPushFilter").add("Tags", tags()).add("Branches", branches()).add("FilePaths", filePaths())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "branches":
            return Optional.ofNullable(clazz.cast(branches()));
        case "filePaths":
            return Optional.ofNullable(clazz.cast(filePaths()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tags", TAGS_FIELD);
        map.put("branches", BRANCHES_FIELD);
        map.put("filePaths", FILE_PATHS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitPushFilter, T> g) {
        return obj -> g.apply((GitPushFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitPushFilter> {
        /**
         * <p>
         * The field that contains the details for the Git tags trigger configuration.
         * </p>
         * 
         * @param tags
         *        The field that contains the details for the Git tags trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(GitTagFilterCriteria tags);

        /**
         * <p>
         * The field that contains the details for the Git tags trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitTagFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link GitTagFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitTagFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(GitTagFilterCriteria)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link GitTagFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(GitTagFilterCriteria)
         */
        default Builder tags(Consumer<GitTagFilterCriteria.Builder> tags) {
            return tags(GitTagFilterCriteria.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * The field that specifies to filter on branches for the push trigger configuration.
         * </p>
         * 
         * @param branches
         *        The field that specifies to filter on branches for the push trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(GitBranchFilterCriteria branches);

        /**
         * <p>
         * The field that specifies to filter on branches for the push trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitBranchFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link GitBranchFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitBranchFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #branches(GitBranchFilterCriteria)}.
         * 
         * @param branches
         *        a consumer that will call methods on {@link GitBranchFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branches(GitBranchFilterCriteria)
         */
        default Builder branches(Consumer<GitBranchFilterCriteria.Builder> branches) {
            return branches(GitBranchFilterCriteria.builder().applyMutation(branches).build());
        }

        /**
         * <p>
         * The field that specifies to filter on file paths for the push trigger configuration.
         * </p>
         * 
         * @param filePaths
         *        The field that specifies to filter on file paths for the push trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(GitFilePathFilterCriteria filePaths);

        /**
         * <p>
         * The field that specifies to filter on file paths for the push trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitFilePathFilterCriteria.Builder}
         * avoiding the need to create one manually via {@link GitFilePathFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitFilePathFilterCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #filePaths(GitFilePathFilterCriteria)}.
         * 
         * @param filePaths
         *        a consumer that will call methods on {@link GitFilePathFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePaths(GitFilePathFilterCriteria)
         */
        default Builder filePaths(Consumer<GitFilePathFilterCriteria.Builder> filePaths) {
            return filePaths(GitFilePathFilterCriteria.builder().applyMutation(filePaths).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GitTagFilterCriteria tags;

        private GitBranchFilterCriteria branches;

        private GitFilePathFilterCriteria filePaths;

        private BuilderImpl() {
        }

        private BuilderImpl(GitPushFilter model) {
            tags(model.tags);
            branches(model.branches);
            filePaths(model.filePaths);
        }

        public final GitTagFilterCriteria.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(GitTagFilterCriteria.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(GitTagFilterCriteria tags) {
            this.tags = tags;
            return this;
        }

        public final GitBranchFilterCriteria.Builder getBranches() {
            return branches != null ? branches.toBuilder() : null;
        }

        public final void setBranches(GitBranchFilterCriteria.BuilderImpl branches) {
            this.branches = branches != null ? branches.build() : null;
        }

        @Override
        public final Builder branches(GitBranchFilterCriteria branches) {
            this.branches = branches;
            return this;
        }

        public final GitFilePathFilterCriteria.Builder getFilePaths() {
            return filePaths != null ? filePaths.toBuilder() : null;
        }

        public final void setFilePaths(GitFilePathFilterCriteria.BuilderImpl filePaths) {
            this.filePaths = filePaths != null ? filePaths.build() : null;
        }

        @Override
        public final Builder filePaths(GitFilePathFilterCriteria filePaths) {
            this.filePaths = filePaths;
            return this;
        }

        @Override
        public GitPushFilter build() {
            return new GitPushFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
