/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListActionTypes</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActionTypesRequest extends CodePipelineRequest implements
        ToCopyableBuilder<ListActionTypesRequest.Builder, ListActionTypesRequest> {
    private static final SdkField<String> ACTION_OWNER_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionOwnerFilter").getter(getter(ListActionTypesRequest::actionOwnerFilterAsString))
            .setter(setter(Builder::actionOwnerFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionOwnerFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListActionTypesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> REGION_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionFilter").getter(getter(ListActionTypesRequest::regionFilter))
            .setter(setter(Builder::regionFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_OWNER_FILTER_FIELD,
            NEXT_TOKEN_FIELD, REGION_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionOwnerFilter;

    private final String nextToken;

    private final String regionFilter;

    private ListActionTypesRequest(BuilderImpl builder) {
        super(builder);
        this.actionOwnerFilter = builder.actionOwnerFilter;
        this.nextToken = builder.nextToken;
        this.regionFilter = builder.regionFilter;
    }

    /**
     * <p>
     * Filters the list of action types to those created by a specified entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOwnerFilter}
     * will return {@link ActionOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionOwnerFilterAsString}.
     * </p>
     * 
     * @return Filters the list of action types to those created by a specified entity.
     * @see ActionOwner
     */
    public final ActionOwner actionOwnerFilter() {
        return ActionOwner.fromValue(actionOwnerFilter);
    }

    /**
     * <p>
     * Filters the list of action types to those created by a specified entity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionOwnerFilter}
     * will return {@link ActionOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionOwnerFilterAsString}.
     * </p>
     * 
     * @return Filters the list of action types to those created by a specified entity.
     * @see ActionOwner
     */
    public final String actionOwnerFilterAsString() {
        return actionOwnerFilter;
    }

    /**
     * <p>
     * An identifier that was returned from the previous list action types call, which can be used to return the next
     * set of action types in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous list action types call, which can be used to return the
     *         next set of action types in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Region to filter on for the list of action types.
     * </p>
     * 
     * @return The Region to filter on for the list of action types.
     */
    public final String regionFilter() {
        return regionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionOwnerFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(regionFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesRequest)) {
            return false;
        }
        ListActionTypesRequest other = (ListActionTypesRequest) obj;
        return Objects.equals(actionOwnerFilterAsString(), other.actionOwnerFilterAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(regionFilter(), other.regionFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActionTypesRequest").add("ActionOwnerFilter", actionOwnerFilterAsString())
                .add("NextToken", nextToken()).add("RegionFilter", regionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionOwnerFilter":
            return Optional.ofNullable(clazz.cast(actionOwnerFilterAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "regionFilter":
            return Optional.ofNullable(clazz.cast(regionFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionOwnerFilter", ACTION_OWNER_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("regionFilter", REGION_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionTypesRequest, T> g) {
        return obj -> g.apply((ListActionTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListActionTypesRequest> {
        /**
         * <p>
         * Filters the list of action types to those created by a specified entity.
         * </p>
         * 
         * @param actionOwnerFilter
         *        Filters the list of action types to those created by a specified entity.
         * @see ActionOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOwner
         */
        Builder actionOwnerFilter(String actionOwnerFilter);

        /**
         * <p>
         * Filters the list of action types to those created by a specified entity.
         * </p>
         * 
         * @param actionOwnerFilter
         *        Filters the list of action types to those created by a specified entity.
         * @see ActionOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOwner
         */
        Builder actionOwnerFilter(ActionOwner actionOwnerFilter);

        /**
         * <p>
         * An identifier that was returned from the previous list action types call, which can be used to return the
         * next set of action types in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous list action types call, which can be used to return
         *        the next set of action types in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Region to filter on for the list of action types.
         * </p>
         * 
         * @param regionFilter
         *        The Region to filter on for the list of action types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionFilter(String regionFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String actionOwnerFilter;

        private String nextToken;

        private String regionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesRequest model) {
            super(model);
            actionOwnerFilter(model.actionOwnerFilter);
            nextToken(model.nextToken);
            regionFilter(model.regionFilter);
        }

        public final String getActionOwnerFilter() {
            return actionOwnerFilter;
        }

        public final void setActionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
        }

        @Override
        public final Builder actionOwnerFilter(String actionOwnerFilter) {
            this.actionOwnerFilter = actionOwnerFilter;
            return this;
        }

        @Override
        public final Builder actionOwnerFilter(ActionOwner actionOwnerFilter) {
            this.actionOwnerFilter(actionOwnerFilter == null ? null : actionOwnerFilter.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegionFilter() {
            return regionFilter;
        }

        public final void setRegionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
        }

        @Override
        public final Builder regionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListActionTypesRequest build() {
            return new ListActionTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
