/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeployActionExecutionTargetsRequest extends CodePipelineRequest implements
        ToCopyableBuilder<ListDeployActionExecutionTargetsRequest.Builder, ListDeployActionExecutionTargetsRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(ListDeployActionExecutionTargetsRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionExecutionId").getter(getter(ListDeployActionExecutionTargetsRequest::actionExecutionId))
            .setter(setter(Builder::actionExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()).build();

    private static final SdkField<List<TargetFilter>> FILTERS_FIELD = SdkField
            .<List<TargetFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListDeployActionExecutionTargetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDeployActionExecutionTargetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeployActionExecutionTargetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            ACTION_EXECUTION_ID_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineName;

    private final String actionExecutionId;

    private final List<TargetFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListDeployActionExecutionTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.actionExecutionId = builder.actionExecutionId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the pipeline with the deploy action.
     * </p>
     * 
     * @return The name of the pipeline with the deploy action.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The execution ID for the deploy action.
     * </p>
     * 
     * @return The execution ID for the deploy action.
     */
    public final String actionExecutionId() {
        return actionExecutionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the targets for a specified deploy action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters the targets for a specified deploy action.
     */
    public final List<TargetFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned nextToken value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned nextToken value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An identifier that was returned from the previous list action types call, which can be used to return the next
     * set of action types in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous list action types call, which can be used to return the
     *         next set of action types in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(actionExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeployActionExecutionTargetsRequest)) {
            return false;
        }
        ListDeployActionExecutionTargetsRequest other = (ListDeployActionExecutionTargetsRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(actionExecutionId(), other.actionExecutionId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeployActionExecutionTargetsRequest").add("PipelineName", pipelineName())
                .add("ActionExecutionId", actionExecutionId()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "actionExecutionId":
            return Optional.ofNullable(clazz.cast(actionExecutionId()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("actionExecutionId", ACTION_EXECUTION_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeployActionExecutionTargetsRequest, T> g) {
        return obj -> g.apply((ListDeployActionExecutionTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeployActionExecutionTargetsRequest> {
        /**
         * <p>
         * The name of the pipeline with the deploy action.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline with the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The execution ID for the deploy action.
         * </p>
         * 
         * @param actionExecutionId
         *        The execution ID for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionId(String actionExecutionId);

        /**
         * <p>
         * Filters the targets for a specified deploy action.
         * </p>
         * 
         * @param filters
         *        Filters the targets for a specified deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<TargetFilter> filters);

        /**
         * <p>
         * Filters the targets for a specified deploy action.
         * </p>
         * 
         * @param filters
         *        Filters the targets for a specified deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(TargetFilter... filters);

        /**
         * <p>
         * Filters the targets for a specified deploy action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.TargetFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.TargetFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.TargetFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<TargetFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.TargetFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<TargetFilter>)
         */
        Builder filters(Consumer<TargetFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned nextToken value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned nextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An identifier that was returned from the previous list action types call, which can be used to return the
         * next set of action types in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous list action types call, which can be used to return
         *        the next set of action types in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String actionExecutionId;

        private List<TargetFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeployActionExecutionTargetsRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            actionExecutionId(model.actionExecutionId);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getActionExecutionId() {
            return actionExecutionId;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final List<TargetFilter.Builder> getFilters() {
            List<TargetFilter.Builder> result = TargetFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TargetFilter.BuilderImpl> filters) {
            this.filters = TargetFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TargetFilter> filters) {
            this.filters = TargetFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TargetFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TargetFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> TargetFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeployActionExecutionTargetsRequest build() {
            return new ListDeployActionExecutionTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
