/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutJobSuccessResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutJobSuccessResultRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutJobSuccessResultRequest.Builder, PutJobSuccessResultRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(PutJobSuccessResultRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<CurrentRevision> CURRENT_REVISION_FIELD = SdkField
            .<CurrentRevision> builder(MarshallingType.SDK_POJO).memberName("currentRevision")
            .getter(getter(PutJobSuccessResultRequest::currentRevision)).setter(setter(Builder::currentRevision))
            .constructor(CurrentRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("continuationToken").getter(getter(PutJobSuccessResultRequest::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).memberName("executionDetails")
            .getter(getter(PutJobSuccessResultRequest::executionDetails)).setter(setter(Builder::executionDetails))
            .constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build()).build();

    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("outputVariables")
            .getter(getter(PutJobSuccessResultRequest::outputVariables))
            .setter(setter(Builder::outputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            CURRENT_REVISION_FIELD, CONTINUATION_TOKEN_FIELD, EXECUTION_DETAILS_FIELD, OUTPUT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final CurrentRevision currentRevision;

    private final String continuationToken;

    private final ExecutionDetails executionDetails;

    private final Map<String, String> outputVariables;

    private PutJobSuccessResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
        this.outputVariables = builder.outputVariables;
    }

    /**
     * <p>
     * The unique system-generated ID of the job that succeeded. This is the same ID returned from
     * <code>PollForJobs</code>.
     * </p>
     * 
     * @return The unique system-generated ID of the job that succeeded. This is the same ID returned from
     *         <code>PollForJobs</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The ID of the current revision of the artifact successfully worked on by the job.
     * </p>
     * 
     * @return The ID of the current revision of the artifact successfully worked on by the job.
     */
    public final CurrentRevision currentRevision() {
        return currentRevision;
    }

    /**
     * <p>
     * A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to identify
     * a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be
     * reused to return more information about the progress of the custom action. When the action is complete, no
     * continuation token should be supplied.
     * </p>
     * 
     * @return A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to
     *         identify a custom action in progress. Future jobs use this token to identify the running instance of the
     *         action. It can be reused to return more information about the progress of the custom action. When the
     *         action is complete, no continuation token should be supplied.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * The execution details of the successful job, such as the actions taken by the job worker.
     * </p>
     * 
     * @return The execution details of the successful job, such as the actions taken by the job worker.
     */
    public final ExecutionDetails executionDetails() {
        return executionDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputVariables() {
        return outputVariables != null && !(outputVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs produced as output by a job worker that can be made available to a downstream action
     * configuration. <code>outputVariables</code> can be included only when there is no continuation token on the
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputVariables} method.
     * </p>
     * 
     * @return Key-value pairs produced as output by a job worker that can be made available to a downstream action
     *         configuration. <code>outputVariables</code> can be included only when there is no continuation token on
     *         the request.
     */
    public final Map<String, String> outputVariables() {
        return outputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputVariables() ? outputVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutJobSuccessResultRequest)) {
            return false;
        }
        PutJobSuccessResultRequest other = (PutJobSuccessResultRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(currentRevision(), other.currentRevision())
                && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(executionDetails(), other.executionDetails())
                && hasOutputVariables() == other.hasOutputVariables()
                && Objects.equals(outputVariables(), other.outputVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutJobSuccessResultRequest").add("JobId", jobId()).add("CurrentRevision", currentRevision())
                .add("ContinuationToken", continuationToken()).add("ExecutionDetails", executionDetails())
                .add("OutputVariables", hasOutputVariables() ? outputVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "currentRevision":
            return Optional.ofNullable(clazz.cast(currentRevision()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "executionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        case "outputVariables":
            return Optional.ofNullable(clazz.cast(outputVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("currentRevision", CURRENT_REVISION_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("outputVariables", OUTPUT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutJobSuccessResultRequest, T> g) {
        return obj -> g.apply((PutJobSuccessResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutJobSuccessResultRequest> {
        /**
         * <p>
         * The unique system-generated ID of the job that succeeded. This is the same ID returned from
         * <code>PollForJobs</code>.
         * </p>
         * 
         * @param jobId
         *        The unique system-generated ID of the job that succeeded. This is the same ID returned from
         *        <code>PollForJobs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * 
         * @param currentRevision
         *        The ID of the current revision of the artifact successfully worked on by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevision(CurrentRevision currentRevision);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentRevision.Builder} avoiding the
         * need to create one manually via {@link CurrentRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrentRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #currentRevision(CurrentRevision)}.
         * 
         * @param currentRevision
         *        a consumer that will call methods on {@link CurrentRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRevision(CurrentRevision)
         */
        default Builder currentRevision(Consumer<CurrentRevision.Builder> currentRevision) {
            return currentRevision(CurrentRevision.builder().applyMutation(currentRevision).build());
        }

        /**
         * <p>
         * A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides to
         * identify a custom action in progress. Future jobs use this token to identify the running instance of the
         * action. It can be reused to return more information about the progress of the custom action. When the action
         * is complete, no continuation token should be supplied.
         * </p>
         * 
         * @param continuationToken
         *        A token generated by a job worker, such as a CodeDeploy deployment ID, that a successful job provides
         *        to identify a custom action in progress. Future jobs use this token to identify the running instance
         *        of the action. It can be reused to return more information about the progress of the custom action.
         *        When the action is complete, no continuation token should be supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * The execution details of the successful job, such as the actions taken by the job worker.
         * </p>
         * 
         * @param executionDetails
         *        The execution details of the successful job, such as the actions taken by the job worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(ExecutionDetails executionDetails);

        /**
         * <p>
         * The execution details of the successful job, such as the actions taken by the job worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionDetails.Builder} avoiding the
         * need to create one manually via {@link ExecutionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #executionDetails(ExecutionDetails)}.
         * 
         * @param executionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionDetails(ExecutionDetails)
         */
        default Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return executionDetails(ExecutionDetails.builder().applyMutation(executionDetails).build());
        }

        /**
         * <p>
         * Key-value pairs produced as output by a job worker that can be made available to a downstream action
         * configuration. <code>outputVariables</code> can be included only when there is no continuation token on the
         * request.
         * </p>
         * 
         * @param outputVariables
         *        Key-value pairs produced as output by a job worker that can be made available to a downstream action
         *        configuration. <code>outputVariables</code> can be included only when there is no continuation token
         *        on the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariables(Map<String, String> outputVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String jobId;

        private CurrentRevision currentRevision;

        private String continuationToken;

        private ExecutionDetails executionDetails;

        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutJobSuccessResultRequest model) {
            super(model);
            jobId(model.jobId);
            currentRevision(model.currentRevision);
            continuationToken(model.continuationToken);
            executionDetails(model.executionDetails);
            outputVariables(model.outputVariables);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return currentRevision != null ? currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return executionDetails != null ? executionDetails.toBuilder() : null;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final Map<String, String> getOutputVariables() {
            if (outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputVariables;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutJobSuccessResultRequest build() {
            return new PutJobSuccessResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
