/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>RetryStageExecution</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryStageExecutionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<RetryStageExecutionRequest.Builder, RetryStageExecutionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(RetryStageExecutionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(RetryStageExecutionRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(RetryStageExecutionRequest::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<String> RETRY_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retryMode").getter(getter(RetryStageExecutionRequest::retryModeAsString))
            .setter(setter(Builder::retryMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, PIPELINE_EXECUTION_ID_FIELD, RETRY_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineName;

    private final String stageName;

    private final String pipelineExecutionId;

    private final String retryMode;

    private RetryStageExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.retryMode = builder.retryMode;
    }

    /**
     * <p>
     * The name of the pipeline that contains the failed stage.
     * </p>
     * 
     * @return The name of the pipeline that contains the failed stage.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the failed stage to be retried.
     * </p>
     * 
     * @return The name of the failed stage to be retried.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a> action to
     * retrieve the current pipelineExecutionId of the failed stage
     * </p>
     * 
     * @return The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a>
     *         action to retrieve the current pipelineExecutionId of the failed stage
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The scope of the retry attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryMode} will
     * return {@link StageRetryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryModeAsString}.
     * </p>
     * 
     * @return The scope of the retry attempt.
     * @see StageRetryMode
     */
    public final StageRetryMode retryMode() {
        return StageRetryMode.fromValue(retryMode);
    }

    /**
     * <p>
     * The scope of the retry attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retryMode} will
     * return {@link StageRetryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retryModeAsString}.
     * </p>
     * 
     * @return The scope of the retry attempt.
     * @see StageRetryMode
     */
    public final String retryModeAsString() {
        return retryMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(retryModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStageExecutionRequest)) {
            return false;
        }
        RetryStageExecutionRequest other = (RetryStageExecutionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(retryModeAsString(), other.retryModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryStageExecutionRequest").add("PipelineName", pipelineName()).add("StageName", stageName())
                .add("PipelineExecutionId", pipelineExecutionId()).add("RetryMode", retryModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "retryMode":
            return Optional.ofNullable(clazz.cast(retryModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        map.put("retryMode", RETRY_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetryStageExecutionRequest, T> g) {
        return obj -> g.apply((RetryStageExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetryStageExecutionRequest> {
        /**
         * <p>
         * The name of the pipeline that contains the failed stage.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline that contains the failed stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the failed stage to be retried.
         * </p>
         * 
         * @param stageName
         *        The name of the failed stage to be retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a> action to
         * retrieve the current pipelineExecutionId of the failed stage
         * </p>
         * 
         * @param pipelineExecutionId
         *        The ID of the pipeline execution in the failed stage to be retried. Use the <a>GetPipelineState</a>
         *        action to retrieve the current pipelineExecutionId of the failed stage
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The scope of the retry attempt.
         * </p>
         * 
         * @param retryMode
         *        The scope of the retry attempt.
         * @see StageRetryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageRetryMode
         */
        Builder retryMode(String retryMode);

        /**
         * <p>
         * The scope of the retry attempt.
         * </p>
         * 
         * @param retryMode
         *        The scope of the retry attempt.
         * @see StageRetryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StageRetryMode
         */
        Builder retryMode(StageRetryMode retryMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String pipelineExecutionId;

        private String retryMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStageExecutionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            pipelineExecutionId(model.pipelineExecutionId);
            retryMode(model.retryMode);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getRetryMode() {
            return retryMode;
        }

        public final void setRetryMode(String retryMode) {
            this.retryMode = retryMode;
        }

        @Override
        public final Builder retryMode(String retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        @Override
        public final Builder retryMode(StageRetryMode retryMode) {
            this.retryMode(retryMode == null ? null : retryMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryStageExecutionRequest build() {
            return new RetryStageExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
