/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackStageRequest extends CodePipelineRequest implements
        ToCopyableBuilder<RollbackStageRequest.Builder, RollbackStageRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(RollbackStageRequest::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(RollbackStageRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> TARGET_PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetPipelineExecutionId").getter(getter(RollbackStageRequest::targetPipelineExecutionId))
            .setter(setter(Builder::targetPipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPipelineExecutionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, TARGET_PIPELINE_EXECUTION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineName;

    private final String stageName;

    private final String targetPipelineExecutionId;

    private RollbackStageRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.targetPipelineExecutionId = builder.targetPipelineExecutionId;
    }

    /**
     * <p>
     * The name of the pipeline for which the stage will be rolled back.
     * </p>
     * 
     * @return The name of the pipeline for which the stage will be rolled back.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the stage in the pipeline to be rolled back.
     * </p>
     * 
     * @return The name of the stage in the pipeline to be rolled back.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The pipeline execution ID for the stage to be rolled back to.
     * </p>
     * 
     * @return The pipeline execution ID for the stage to be rolled back to.
     */
    public final String targetPipelineExecutionId() {
        return targetPipelineExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(targetPipelineExecutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackStageRequest)) {
            return false;
        }
        RollbackStageRequest other = (RollbackStageRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(targetPipelineExecutionId(), other.targetPipelineExecutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackStageRequest").add("PipelineName", pipelineName()).add("StageName", stageName())
                .add("TargetPipelineExecutionId", targetPipelineExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "targetPipelineExecutionId":
            return Optional.ofNullable(clazz.cast(targetPipelineExecutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("targetPipelineExecutionId", TARGET_PIPELINE_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollbackStageRequest, T> g) {
        return obj -> g.apply((RollbackStageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, RollbackStageRequest> {
        /**
         * <p>
         * The name of the pipeline for which the stage will be rolled back.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline for which the stage will be rolled back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the stage in the pipeline to be rolled back.
         * </p>
         * 
         * @param stageName
         *        The name of the stage in the pipeline to be rolled back.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The pipeline execution ID for the stage to be rolled back to.
         * </p>
         * 
         * @param targetPipelineExecutionId
         *        The pipeline execution ID for the stage to be rolled back to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPipelineExecutionId(String targetPipelineExecutionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String targetPipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackStageRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            targetPipelineExecutionId(model.targetPipelineExecutionId);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getTargetPipelineExecutionId() {
            return targetPipelineExecutionId;
        }

        public final void setTargetPipelineExecutionId(String targetPipelineExecutionId) {
            this.targetPipelineExecutionId = targetPipelineExecutionId;
        }

        @Override
        public final Builder targetPipelineExecutionId(String targetPipelineExecutionId) {
            this.targetPipelineExecutionId = targetPipelineExecutionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RollbackStageRequest build() {
            return new RollbackStageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
