/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter values for the action execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionFilter.Builder, ActionExecutionFilter> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineExecutionId").getter(getter(ActionExecutionFilter::pipelineExecutionId))
            .setter(setter(Builder::pipelineExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build())
            .build();

    private static final SdkField<LatestInPipelineExecutionFilter> LATEST_IN_PIPELINE_EXECUTION_FIELD = SdkField
            .<LatestInPipelineExecutionFilter> builder(MarshallingType.SDK_POJO).memberName("latestInPipelineExecution")
            .getter(getter(ActionExecutionFilter::latestInPipelineExecution)).setter(setter(Builder::latestInPipelineExecution))
            .constructor(LatestInPipelineExecutionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestInPipelineExecution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD,
            LATEST_IN_PIPELINE_EXECUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pipelineExecutionId;

    private final LatestInPipelineExecutionFilter latestInPipelineExecution;

    private ActionExecutionFilter(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.latestInPipelineExecution = builder.latestInPipelineExecution;
    }

    /**
     * <p>
     * The pipeline execution ID used to filter action execution history.
     * </p>
     * 
     * @return The pipeline execution ID used to filter action execution history.
     */
    public final String pipelineExecutionId() {
        return pipelineExecutionId;
    }

    /**
     * <p>
     * The latest execution in the pipeline.
     * </p>
     * <note>
     * <p>
     * Filtering on the latest execution is available for executions run on or after February 08, 2024.
     * </p>
     * </note>
     * 
     * @return The latest execution in the pipeline.</p> <note>
     *         <p>
     *         Filtering on the latest execution is available for executions run on or after February 08, 2024.
     *         </p>
     */
    public final LatestInPipelineExecutionFilter latestInPipelineExecution() {
        return latestInPipelineExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(latestInPipelineExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionFilter)) {
            return false;
        }
        ActionExecutionFilter other = (ActionExecutionFilter) obj;
        return Objects.equals(pipelineExecutionId(), other.pipelineExecutionId())
                && Objects.equals(latestInPipelineExecution(), other.latestInPipelineExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecutionFilter").add("PipelineExecutionId", pipelineExecutionId())
                .add("LatestInPipelineExecution", latestInPipelineExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineExecutionId":
            return Optional.ofNullable(clazz.cast(pipelineExecutionId()));
        case "latestInPipelineExecution":
            return Optional.ofNullable(clazz.cast(latestInPipelineExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        map.put("latestInPipelineExecution", LATEST_IN_PIPELINE_EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionFilter, T> g) {
        return obj -> g.apply((ActionExecutionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionFilter> {
        /**
         * <p>
         * The pipeline execution ID used to filter action execution history.
         * </p>
         * 
         * @param pipelineExecutionId
         *        The pipeline execution ID used to filter action execution history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionId(String pipelineExecutionId);

        /**
         * <p>
         * The latest execution in the pipeline.
         * </p>
         * <note>
         * <p>
         * Filtering on the latest execution is available for executions run on or after February 08, 2024.
         * </p>
         * </note>
         * 
         * @param latestInPipelineExecution
         *        The latest execution in the pipeline.</p> <note>
         *        <p>
         *        Filtering on the latest execution is available for executions run on or after February 08, 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestInPipelineExecution(LatestInPipelineExecutionFilter latestInPipelineExecution);

        /**
         * <p>
         * The latest execution in the pipeline.
         * </p>
         * <note>
         * <p>
         * Filtering on the latest execution is available for executions run on or after February 08, 2024.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link LatestInPipelineExecutionFilter.Builder} avoiding the need to create one manually via
         * {@link LatestInPipelineExecutionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestInPipelineExecutionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #latestInPipelineExecution(LatestInPipelineExecutionFilter)}.
         * 
         * @param latestInPipelineExecution
         *        a consumer that will call methods on {@link LatestInPipelineExecutionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestInPipelineExecution(LatestInPipelineExecutionFilter)
         */
        default Builder latestInPipelineExecution(Consumer<LatestInPipelineExecutionFilter.Builder> latestInPipelineExecution) {
            return latestInPipelineExecution(LatestInPipelineExecutionFilter.builder().applyMutation(latestInPipelineExecution)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String pipelineExecutionId;

        private LatestInPipelineExecutionFilter latestInPipelineExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionFilter model) {
            pipelineExecutionId(model.pipelineExecutionId);
            latestInPipelineExecution(model.latestInPipelineExecution);
        }

        public final String getPipelineExecutionId() {
            return pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final LatestInPipelineExecutionFilter.Builder getLatestInPipelineExecution() {
            return latestInPipelineExecution != null ? latestInPipelineExecution.toBuilder() : null;
        }

        public final void setLatestInPipelineExecution(LatestInPipelineExecutionFilter.BuilderImpl latestInPipelineExecution) {
            this.latestInPipelineExecution = latestInPipelineExecution != null ? latestInPipelineExecution.build() : null;
        }

        @Override
        public final Builder latestInPipelineExecution(LatestInPipelineExecutionFilter latestInPipelineExecution) {
            this.latestInPipelineExecution = latestInPipelineExecution;
            return this;
        }

        @Override
        public ActionExecutionFilter build() {
            return new ActionExecutionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
