/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the category, owner, provider, and version of the action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionTypeIdentifier.Builder, ActionTypeIdentifier> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ActionTypeIdentifier::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ActionTypeIdentifier::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ActionTypeIdentifier::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ActionTypeIdentifier::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, OWNER_FIELD,
            PROVIDER_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String owner;

    private final String provider;

    private final String version;

    private ActionTypeIdentifier(BuilderImpl builder) {
        this.category = builder.category;
        this.owner = builder.owner;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    /**
     * <p>
     * Defines what kind of action can be taken in the stage, one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Source</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Build</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Test</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approval</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Invoke</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Defines what kind of action can be taken in the stage, one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Source</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Build</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Test</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approval</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Invoke</code>
     *         </p>
     *         </li>
     * @see ActionCategory
     */
    public final ActionCategory category() {
        return ActionCategory.fromValue(category);
    }

    /**
     * <p>
     * Defines what kind of action can be taken in the stage, one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Source</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Build</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Test</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approval</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Invoke</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Defines what kind of action can be taken in the stage, one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Source</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Build</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Test</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approval</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Invoke</code>
     *         </p>
     *         </li>
     * @see ActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.
     * </p>
     * 
     * @return The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The provider of the action type being called. The provider name is supplied when the action type is created.
     * </p>
     * 
     * @return The provider of the action type being called. The provider name is supplied when the action type is
     *         created.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * A string that describes the action type version.
     * </p>
     * 
     * @return A string that describes the action type version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeIdentifier)) {
            return false;
        }
        ActionTypeIdentifier other = (ActionTypeIdentifier) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(owner(), other.owner())
                && Objects.equals(provider(), other.provider()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeIdentifier").add("Category", categoryAsString()).add("Owner", owner())
                .add("Provider", provider()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("category", CATEGORY_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeIdentifier, T> g) {
        return obj -> g.apply((ActionTypeIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeIdentifier> {
        /**
         * <p>
         * Defines what kind of action can be taken in the stage, one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Source</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Build</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Test</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approval</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Invoke</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        Defines what kind of action can be taken in the stage, one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Source</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Build</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Test</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approval</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Invoke</code>
         *        </p>
         *        </li>
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(String category);

        /**
         * <p>
         * Defines what kind of action can be taken in the stage, one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Source</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Build</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Test</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approval</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Invoke</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        Defines what kind of action can be taken in the stage, one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Source</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Build</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Test</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approval</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Invoke</code>
         *        </p>
         *        </li>
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(ActionCategory category);

        /**
         * <p>
         * The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.
         * </p>
         * 
         * @param owner
         *        The creator of the action type being called: <code>AWS</code> or <code>ThirdParty</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The provider of the action type being called. The provider name is supplied when the action type is created.
         * </p>
         * 
         * @param provider
         *        The provider of the action type being called. The provider name is supplied when the action type is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * A string that describes the action type version.
         * </p>
         * 
         * @param version
         *        A string that describes the action type version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String owner;

        private String provider;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeIdentifier model) {
            category(model.category);
            owner(model.owner);
            provider(model.provider);
            version(model.version);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ActionTypeIdentifier build() {
            return new ActionTypeIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
