/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target for the deploy action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployActionExecutionTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DeployActionExecutionTarget.Builder, DeployActionExecutionTarget> {
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetId").getter(getter(DeployActionExecutionTarget::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(DeployActionExecutionTarget::targetType)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeployActionExecutionTarget::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DeployActionExecutionTarget::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DeployActionExecutionTarget::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<List<DeployTargetEvent>> EVENTS_FIELD = SdkField
            .<List<DeployTargetEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(DeployActionExecutionTarget::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeployTargetEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeployTargetEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FIELD,
            TARGET_TYPE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetId;

    private final String targetType;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final List<DeployTargetEvent> events;

    private DeployActionExecutionTarget(BuilderImpl builder) {
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.events = builder.events;
    }

    /**
     * <p>
     * The ID of the target for the deploy action.
     * </p>
     * 
     * @return The ID of the target for the deploy action.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of target for the deploy action.
     * </p>
     * 
     * @return The type of target for the deploy action.
     */
    public final String targetType() {
        return targetType;
    }

    /**
     * <p>
     * The status of the deploy action.
     * </p>
     * 
     * @return The status of the deploy action.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The start time for the deploy action.
     * </p>
     * 
     * @return The start time for the deploy action.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the deploy action.
     * </p>
     * 
     * @return The end time for the deploy action.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The lifecycle events for the deploy action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The lifecycle events for the deploy action.
     */
    public final List<DeployTargetEvent> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployActionExecutionTarget)) {
            return false;
        }
        DeployActionExecutionTarget other = (DeployActionExecutionTarget) obj;
        return Objects.equals(targetId(), other.targetId()) && Objects.equals(targetType(), other.targetType())
                && Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployActionExecutionTarget").add("TargetId", targetId()).add("TargetType", targetType())
                .add("Status", status()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetType()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeployActionExecutionTarget, T> g) {
        return obj -> g.apply((DeployActionExecutionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeployActionExecutionTarget> {
        /**
         * <p>
         * The ID of the target for the deploy action.
         * </p>
         * 
         * @param targetId
         *        The ID of the target for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of target for the deploy action.
         * </p>
         * 
         * @param targetType
         *        The type of target for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The status of the deploy action.
         * </p>
         * 
         * @param status
         *        The status of the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The start time for the deploy action.
         * </p>
         * 
         * @param startTime
         *        The start time for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the deploy action.
         * </p>
         * 
         * @param endTime
         *        The end time for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The lifecycle events for the deploy action.
         * </p>
         * 
         * @param events
         *        The lifecycle events for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<DeployTargetEvent> events);

        /**
         * <p>
         * The lifecycle events for the deploy action.
         * </p>
         * 
         * @param events
         *        The lifecycle events for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(DeployTargetEvent... events);

        /**
         * <p>
         * The lifecycle events for the deploy action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.DeployTargetEvent.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.DeployTargetEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.DeployTargetEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #events(List<DeployTargetEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.DeployTargetEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<DeployTargetEvent>)
         */
        Builder events(Consumer<DeployTargetEvent.Builder>... events);
    }

    static final class BuilderImpl implements Builder {
        private String targetId;

        private String targetType;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private List<DeployTargetEvent> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeployActionExecutionTarget model) {
            targetId(model.targetId);
            targetType(model.targetType);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            events(model.events);
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<DeployTargetEvent.Builder> getEvents() {
            List<DeployTargetEvent.Builder> result = DeployTargetEventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<DeployTargetEvent.BuilderImpl> events) {
            this.events = DeployTargetEventListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<DeployTargetEvent> events) {
            this.events = DeployTargetEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(DeployTargetEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<DeployTargetEvent.Builder>... events) {
            events(Stream.of(events).map(c -> DeployTargetEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeployActionExecutionTarget build() {
            return new DeployActionExecutionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
