/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A lifecycle event for the deploy action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeployTargetEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<DeployTargetEvent.Builder, DeployTargetEvent> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeployTargetEvent::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeployTargetEvent::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(DeployTargetEvent::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(DeployTargetEvent::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<DeployTargetEventContext> CONTEXT_FIELD = SdkField
            .<DeployTargetEventContext> builder(MarshallingType.SDK_POJO).memberName("context")
            .getter(getter(DeployTargetEvent::context)).setter(setter(Builder::context))
            .constructor(DeployTargetEventContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final DeployTargetEventContext context;

    private DeployTargetEvent(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.context = builder.context;
    }

    /**
     * <p>
     * The name of the event for the deploy action.
     * </p>
     * 
     * @return The name of the event for the deploy action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the event for the deploy action.
     * </p>
     * 
     * @return The status of the event for the deploy action.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The start time for the event for the deploy action.
     * </p>
     * 
     * @return The start time for the event for the deploy action.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the event for the deploy action.
     * </p>
     * 
     * @return The end time for the event for the deploy action.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The context for the event for the deploy action.
     * </p>
     * 
     * @return The context for the event for the deploy action.
     */
    public final DeployTargetEventContext context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployTargetEvent)) {
            return false;
        }
        DeployTargetEvent other = (DeployTargetEvent) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeployTargetEvent").add("Name", name()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("context", CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeployTargetEvent, T> g) {
        return obj -> g.apply((DeployTargetEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeployTargetEvent> {
        /**
         * <p>
         * The name of the event for the deploy action.
         * </p>
         * 
         * @param name
         *        The name of the event for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the event for the deploy action.
         * </p>
         * 
         * @param status
         *        The status of the event for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The start time for the event for the deploy action.
         * </p>
         * 
         * @param startTime
         *        The start time for the event for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time for the event for the deploy action.
         * </p>
         * 
         * @param endTime
         *        The end time for the event for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The context for the event for the deploy action.
         * </p>
         * 
         * @param context
         *        The context for the event for the deploy action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(DeployTargetEventContext context);

        /**
         * <p>
         * The context for the event for the deploy action.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeployTargetEventContext.Builder}
         * avoiding the need to create one manually via {@link DeployTargetEventContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeployTargetEventContext.Builder#build()} is called immediately
         * and its result is passed to {@link #context(DeployTargetEventContext)}.
         * 
         * @param context
         *        a consumer that will call methods on {@link DeployTargetEventContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #context(DeployTargetEventContext)
         */
        default Builder context(Consumer<DeployTargetEventContext.Builder> context) {
            return context(DeployTargetEventContext.builder().applyMutation(context).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private DeployTargetEventContext context;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployTargetEvent model) {
            name(model.name);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            context(model.context);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final DeployTargetEventContext.Builder getContext() {
            return context != null ? context.toBuilder() : null;
        }

        public final void setContext(DeployTargetEventContext.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(DeployTargetEventContext context) {
            this.context = context;
            return this;
        }

        @Override
        public DeployTargetEvent build() {
            return new DeployTargetEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
