/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleTypesResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListRuleTypesResponse.Builder, ListRuleTypesResponse> {
    private static final SdkField<List<RuleType>> RULE_TYPES_FIELD = SdkField
            .<List<RuleType>> builder(MarshallingType.LIST)
            .memberName("ruleTypes")
            .getter(getter(ListRuleTypesResponse::ruleTypes))
            .setter(setter(Builder::ruleTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleType> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RuleType> ruleTypes;

    private ListRuleTypesResponse(BuilderImpl builder) {
        super(builder);
        this.ruleTypes = builder.ruleTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleTypes() {
        return ruleTypes != null && !(ruleTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the rules that are configured for the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleTypes} method.
     * </p>
     * 
     * @return Lists the rules that are configured for the condition.
     */
    public final List<RuleType> ruleTypes() {
        return ruleTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleTypes() ? ruleTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleTypesResponse)) {
            return false;
        }
        ListRuleTypesResponse other = (ListRuleTypesResponse) obj;
        return hasRuleTypes() == other.hasRuleTypes() && Objects.equals(ruleTypes(), other.ruleTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRuleTypesResponse").add("RuleTypes", hasRuleTypes() ? ruleTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleTypes":
            return Optional.ofNullable(clazz.cast(ruleTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleTypes", RULE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRuleTypesResponse, T> g) {
        return obj -> g.apply((ListRuleTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRuleTypesResponse> {
        /**
         * <p>
         * Lists the rules that are configured for the condition.
         * </p>
         * 
         * @param ruleTypes
         *        Lists the rules that are configured for the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleTypes(Collection<RuleType> ruleTypes);

        /**
         * <p>
         * Lists the rules that are configured for the condition.
         * </p>
         * 
         * @param ruleTypes
         *        Lists the rules that are configured for the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleTypes(RuleType... ruleTypes);

        /**
         * <p>
         * Lists the rules that are configured for the condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codepipeline.model.RuleType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleType.Builder#build()} is called immediately and
         * its result is passed to {@link #ruleTypes(List<RuleType>)}.
         * 
         * @param ruleTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.RuleType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleTypes(java.util.Collection<RuleType>)
         */
        Builder ruleTypes(Consumer<RuleType.Builder>... ruleTypes);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<RuleType> ruleTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleTypesResponse model) {
            super(model);
            ruleTypes(model.ruleTypes);
        }

        public final List<RuleType.Builder> getRuleTypes() {
            List<RuleType.Builder> result = RuleTypeListCopier.copyToBuilder(this.ruleTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleTypes(Collection<RuleType.BuilderImpl> ruleTypes) {
            this.ruleTypes = RuleTypeListCopier.copyFromBuilder(ruleTypes);
        }

        @Override
        public final Builder ruleTypes(Collection<RuleType> ruleTypes) {
            this.ruleTypes = RuleTypeListCopier.copy(ruleTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleTypes(RuleType... ruleTypes) {
            ruleTypes(Arrays.asList(ruleTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleTypes(Consumer<RuleType.Builder>... ruleTypes) {
            ruleTypes(Stream.of(ruleTypes).map(c -> RuleType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRuleTypesResponse build() {
            return new ListRuleTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
