/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the state of transitions between one stage and another stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitionState implements SdkPojo, Serializable, ToCopyableBuilder<TransitionState.Builder, TransitionState> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(TransitionState::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> LAST_CHANGED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastChangedBy").getter(getter(TransitionState::lastChangedBy)).setter(setter(Builder::lastChangedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastChangedBy").build()).build();

    private static final SdkField<Instant> LAST_CHANGED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastChangedAt").getter(getter(TransitionState::lastChangedAt)).setter(setter(Builder::lastChangedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastChangedAt").build()).build();

    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("disabledReason").getter(getter(TransitionState::disabledReason)).setter(setter(Builder::disabledReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disabledReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LAST_CHANGED_BY_FIELD, LAST_CHANGED_AT_FIELD, DISABLED_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String lastChangedBy;

    private final Instant lastChangedAt;

    private final String disabledReason;

    private TransitionState(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lastChangedBy = builder.lastChangedBy;
        this.lastChangedAt = builder.lastChangedAt;
        this.disabledReason = builder.disabledReason;
    }

    /**
     * <p>
     * Whether the transition between stages is enabled (true) or disabled (false).
     * </p>
     * 
     * @return Whether the transition between stages is enabled (true) or disabled (false).
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The ID of the user who last changed the transition state.
     * </p>
     * 
     * @return The ID of the user who last changed the transition state.
     */
    public final String lastChangedBy() {
        return lastChangedBy;
    }

    /**
     * <p>
     * The timestamp when the transition state was last changed.
     * </p>
     * 
     * @return The timestamp when the transition state was last changed.
     */
    public final Instant lastChangedAt() {
        return lastChangedAt;
    }

    /**
     * <p>
     * The user-specified reason why the transition between two stages of a pipeline was disabled.
     * </p>
     * 
     * @return The user-specified reason why the transition between two stages of a pipeline was disabled.
     */
    public final String disabledReason() {
        return disabledReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(lastChangedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(disabledReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitionState)) {
            return false;
        }
        TransitionState other = (TransitionState) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(lastChangedBy(), other.lastChangedBy())
                && Objects.equals(lastChangedAt(), other.lastChangedAt())
                && Objects.equals(disabledReason(), other.disabledReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitionState").add("Enabled", enabled()).add("LastChangedBy", lastChangedBy())
                .add("LastChangedAt", lastChangedAt()).add("DisabledReason", disabledReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "lastChangedBy":
            return Optional.ofNullable(clazz.cast(lastChangedBy()));
        case "lastChangedAt":
            return Optional.ofNullable(clazz.cast(lastChangedAt()));
        case "disabledReason":
            return Optional.ofNullable(clazz.cast(disabledReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("lastChangedBy", LAST_CHANGED_BY_FIELD);
        map.put("lastChangedAt", LAST_CHANGED_AT_FIELD);
        map.put("disabledReason", DISABLED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitionState, T> g) {
        return obj -> g.apply((TransitionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitionState> {
        /**
         * <p>
         * Whether the transition between stages is enabled (true) or disabled (false).
         * </p>
         * 
         * @param enabled
         *        Whether the transition between stages is enabled (true) or disabled (false).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The ID of the user who last changed the transition state.
         * </p>
         * 
         * @param lastChangedBy
         *        The ID of the user who last changed the transition state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastChangedBy(String lastChangedBy);

        /**
         * <p>
         * The timestamp when the transition state was last changed.
         * </p>
         * 
         * @param lastChangedAt
         *        The timestamp when the transition state was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastChangedAt(Instant lastChangedAt);

        /**
         * <p>
         * The user-specified reason why the transition between two stages of a pipeline was disabled.
         * </p>
         * 
         * @param disabledReason
         *        The user-specified reason why the transition between two stages of a pipeline was disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledReason(String disabledReason);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String lastChangedBy;

        private Instant lastChangedAt;

        private String disabledReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitionState model) {
            enabled(model.enabled);
            lastChangedBy(model.lastChangedBy);
            lastChangedAt(model.lastChangedAt);
            disabledReason(model.disabledReason);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getLastChangedBy() {
            return lastChangedBy;
        }

        public final void setLastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
        }

        @Override
        public final Builder lastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
            return this;
        }

        public final Instant getLastChangedAt() {
            return lastChangedAt;
        }

        public final void setLastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
        }

        @Override
        public final Builder lastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
            return this;
        }

        public final String getDisabledReason() {
            return disabledReason;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        @Override
        public TransitionState build() {
            return new TransitionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
