/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codepipeline.CodePipelineClient;
import software.amazon.awssdk.services.codepipeline.CodePipelineServiceClientConfiguration;
import software.amazon.awssdk.services.codepipeline.internal.CodePipelineServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobResponse;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.ApprovalAlreadyCompletedException;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codepipeline.model.ConcurrentPipelineExecutionsLimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ConditionNotOverridableException;
import software.amazon.awssdk.services.codepipeline.model.ConflictException;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteCustomActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.DeletePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.DeleteWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.DeregisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.DisableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.DuplicatedStopRequestException;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionRequest;
import software.amazon.awssdk.services.codepipeline.model.EnableStageTransitionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.GetActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateRequest;
import software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import software.amazon.awssdk.services.codepipeline.model.GetThirdPartyJobDetailsResponse;
import software.amazon.awssdk.services.codepipeline.model.InvalidActionDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidApprovalTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidArnException;
import software.amazon.awssdk.services.codepipeline.model.InvalidBlockerDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidClientTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobException;
import software.amazon.awssdk.services.codepipeline.model.InvalidJobStateException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codepipeline.model.InvalidNonceException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStageDeclarationException;
import software.amazon.awssdk.services.codepipeline.model.InvalidStructureException;
import software.amazon.awssdk.services.codepipeline.model.InvalidTagsException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookAuthenticationParametersException;
import software.amazon.awssdk.services.codepipeline.model.InvalidWebhookFilterPatternException;
import software.amazon.awssdk.services.codepipeline.model.JobNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.LimitExceededException;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListActionTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelinesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest;
import software.amazon.awssdk.services.codepipeline.model.ListRuleTypesResponse;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksRequest;
import software.amazon.awssdk.services.codepipeline.model.ListWebhooksResponse;
import software.amazon.awssdk.services.codepipeline.model.NotLatestPipelineExecutionException;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesSizeExceededException;
import software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest;
import software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionNotStoppableException;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionOutdatedException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNameInUseException;
import software.amazon.awssdk.services.codepipeline.model.PipelineNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PipelineVersionNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest;
import software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest;
import software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultResponse;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest;
import software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyRequest;
import software.amazon.awssdk.services.codepipeline.model.RegisterWebhookWithThirdPartyResponse;
import software.amazon.awssdk.services.codepipeline.model.RequestFailedException;
import software.amazon.awssdk.services.codepipeline.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageRequest;
import software.amazon.awssdk.services.codepipeline.model.RollbackStageResponse;
import software.amazon.awssdk.services.codepipeline.model.StageNotFoundException;
import software.amazon.awssdk.services.codepipeline.model.StageNotRetryableException;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.codepipeline.model.TagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.TagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.TooManyTagsException;
import software.amazon.awssdk.services.codepipeline.model.UnableToRollbackStageException;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceRequest;
import software.amazon.awssdk.services.codepipeline.model.UntagResourceResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeResponse;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.ValidationException;
import software.amazon.awssdk.services.codepipeline.model.WebhookNotFoundException;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.AcknowledgeThirdPartyJobRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreateCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteCustomActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeleteWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DeregisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.DisableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.EnableStageTransitionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetPipelineStateRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.GetThirdPartyJobDetailsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListActionTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListDeployActionExecutionTargetsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelineExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListRuleExecutionsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListRuleTypesRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.ListWebhooksRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.OverrideStageConditionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PollForThirdPartyJobsRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutActionRevisionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutApprovalResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobFailureResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutThirdPartyJobSuccessResultRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.PutWebhookRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RegisterWebhookWithThirdPartyRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RetryStageExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.RollbackStageRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StartPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.StopPipelineExecutionRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdateActionTypeRequestMarshaller;
import software.amazon.awssdk.services.codepipeline.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCodePipelineClient
implements CodePipelineClient {
    private static final Logger log = Logger.loggerFor(DefaultCodePipelineClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodePipelineClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CodePipeline#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeJobResponse acknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, acknowledgeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeJob");
            AcknowledgeJobResponse acknowledgeJobResponse = (AcknowledgeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acknowledgeJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcknowledgeJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acknowledgeJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$acknowledgeJob$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) throws ValidationException, InvalidNonceException, JobNotFoundException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcknowledgeThirdPartyJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acknowledgeThirdPartyJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, acknowledgeThirdPartyJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcknowledgeThirdPartyJob");
            AcknowledgeThirdPartyJobResponse acknowledgeThirdPartyJobResponse = (AcknowledgeThirdPartyJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcknowledgeThirdPartyJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acknowledgeThirdPartyJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcknowledgeThirdPartyJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acknowledgeThirdPartyJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$acknowledgeThirdPartyJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomActionTypeResponse createCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) throws ValidationException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomActionTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, createCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomActionType");
            CreateCustomActionTypeResponse createCustomActionTypeResponse = (CreateCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCustomActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$createCustomActionType$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ValidationException, PipelineNameInUseException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            CreatePipelineResponse createPipelineResponse = (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$createPipeline$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomActionTypeResponse deleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomActionTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deleteCustomActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomActionType");
            DeleteCustomActionTypeResponse deleteCustomActionTypeResponse = (DeleteCustomActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCustomActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deleteCustomActionType$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            DeletePipelineResponse deletePipelineResponse = (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deletePipeline$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebhookResponse deleteWebhook(DeleteWebhookRequest deleteWebhookRequest) throws ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWebhookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deleteWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWebhook");
            DeleteWebhookResponse deleteWebhookResponse = (DeleteWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deleteWebhook$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterWebhookWithThirdPartyResponse deregisterWebhookWithThirdParty(DeregisterWebhookWithThirdPartyRequest deregisterWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterWebhookWithThirdPartyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, deregisterWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterWebhookWithThirdParty");
            DeregisterWebhookWithThirdPartyResponse deregisterWebhookWithThirdPartyResponse = (DeregisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterWebhookWithThirdPartyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterWebhookWithThirdPartyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$deregisterWebhookWithThirdParty$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableStageTransitionResponse disableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableStageTransitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, disableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableStageTransition");
            DisableStageTransitionResponse disableStageTransitionResponse = (DisableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableStageTransitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableStageTransitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$disableStageTransition$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableStageTransitionResponse enableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) throws ValidationException, PipelineNotFoundException, StageNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableStageTransitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableStageTransitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, enableStageTransitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableStageTransition");
            EnableStageTransitionResponse enableStageTransitionResponse = (EnableStageTransitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableStageTransition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableStageTransitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableStageTransitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableStageTransitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$enableStageTransition$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetActionTypeResponse getActionType(GetActionTypeRequest getActionTypeRequest) throws ActionTypeNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActionTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActionType");
            GetActionTypeResponse getActionTypeResponse = (GetActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getActionType$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobDetailsResponse getJobDetails(GetJobDetailsRequest getJobDetailsRequest) throws ValidationException, JobNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetJobDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobDetails");
            GetJobDetailsResponse getJobDetailsResponse = (GetJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getJobDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getJobDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getJobDetails$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws ValidationException, PipelineNotFoundException, PipelineVersionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipeline");
            GetPipelineResponse getPipelineResponse = (GetPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipeline$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineExecutionResponse getPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) throws ValidationException, PipelineNotFoundException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineExecution");
            GetPipelineExecutionResponse getPipelineExecutionResponse = (GetPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipelineExecution$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineStateResponse getPipelineState(GetPipelineStateRequest getPipelineStateRequest) throws ValidationException, PipelineNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getPipelineStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineState");
            GetPipelineStateResponse getPipelineStateResponse = (GetPipelineStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getPipelineState$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetThirdPartyJobDetailsResponse getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) throws JobNotFoundException, ValidationException, InvalidClientTokenException, InvalidJobException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetThirdPartyJobDetailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getThirdPartyJobDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, getThirdPartyJobDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetThirdPartyJobDetails");
            GetThirdPartyJobDetailsResponse getThirdPartyJobDetailsResponse = (GetThirdPartyJobDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetThirdPartyJobDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getThirdPartyJobDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetThirdPartyJobDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getThirdPartyJobDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$getThirdPartyJobDetails$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActionExecutionsResponse listActionExecutions(ListActionExecutionsRequest listActionExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listActionExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionExecutions");
            ListActionExecutionsResponse listActionExecutionsResponse = (ListActionExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listActionExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActionExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActionExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listActionExecutions$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListActionTypesResponse listActionTypes(ListActionTypesRequest listActionTypesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListActionTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listActionTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listActionTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListActionTypes");
            ListActionTypesResponse listActionTypesResponse = (ListActionTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListActionTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listActionTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListActionTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listActionTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listActionTypes$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDeployActionExecutionTargetsResponse listDeployActionExecutionTargets(ListDeployActionExecutionTargetsRequest listDeployActionExecutionTargetsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, ActionExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDeployActionExecutionTargetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDeployActionExecutionTargetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listDeployActionExecutionTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDeployActionExecutionTargets");
            ListDeployActionExecutionTargetsResponse listDeployActionExecutionTargetsResponse = (ListDeployActionExecutionTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDeployActionExecutionTargets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDeployActionExecutionTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDeployActionExecutionTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDeployActionExecutionTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listDeployActionExecutionTargets$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineExecutionsResponse listPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listPipelineExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineExecutions");
            ListPipelineExecutionsResponse listPipelineExecutionsResponse = (ListPipelineExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelineExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listPipelineExecutions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            ListPipelinesResponse listPipelinesResponse = (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listPipelines$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleExecutionsResponse listRuleExecutions(ListRuleExecutionsRequest listRuleExecutionsRequest) throws ValidationException, PipelineNotFoundException, InvalidNextTokenException, PipelineExecutionNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleExecutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listRuleExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleExecutions");
            ListRuleExecutionsResponse listRuleExecutionsResponse = (ListRuleExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRuleExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listRuleExecutions$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleTypesResponse listRuleTypes(ListRuleTypesRequest listRuleTypesRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRuleTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRuleTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listRuleTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuleTypes");
            ListRuleTypesResponse listRuleTypesResponse = (ListRuleTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuleTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRuleTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRuleTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRuleTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listRuleTypes$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, InvalidArnException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listTagsForResource$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebhooksResponse listWebhooks(ListWebhooksRequest listWebhooksRequest) throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebhooksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listWebhooksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, listWebhooksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWebhooks");
            ListWebhooksResponse listWebhooksResponse = (ListWebhooksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebhooks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listWebhooksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWebhooksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWebhooksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$listWebhooks$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverrideStageConditionResponse overrideStageCondition(OverrideStageConditionRequest overrideStageConditionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, StageNotFoundException, ConditionNotOverridableException, NotLatestPipelineExecutionException, ConcurrentPipelineExecutionsLimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OverrideStageConditionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)overrideStageConditionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, overrideStageConditionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OverrideStageCondition");
            OverrideStageConditionResponse overrideStageConditionResponse = (OverrideStageConditionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("OverrideStageCondition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)overrideStageConditionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new OverrideStageConditionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return overrideStageConditionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$overrideStageCondition$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForJobsResponse pollForJobs(PollForJobsRequest pollForJobsRequest) throws ValidationException, ActionTypeNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, pollForJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForJobs");
            PollForJobsResponse pollForJobsResponse = (PollForJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)pollForJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PollForJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pollForJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$pollForJobs$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForThirdPartyJobsResponse pollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) throws ActionTypeNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PollForThirdPartyJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pollForThirdPartyJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, pollForThirdPartyJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PollForThirdPartyJobs");
            PollForThirdPartyJobsResponse pollForThirdPartyJobsResponse = (PollForThirdPartyJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PollForThirdPartyJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)pollForThirdPartyJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PollForThirdPartyJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pollForThirdPartyJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$pollForThirdPartyJobs$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutActionRevisionResponse putActionRevision(PutActionRevisionRequest putActionRevisionRequest) throws PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, ConcurrentPipelineExecutionsLimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutActionRevisionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putActionRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putActionRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutActionRevision");
            PutActionRevisionResponse putActionRevisionResponse = (PutActionRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutActionRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putActionRevisionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutActionRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putActionRevisionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putActionRevision$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApprovalResultResponse putApprovalResult(PutApprovalResultRequest putApprovalResultRequest) throws InvalidApprovalTokenException, ApprovalAlreadyCompletedException, PipelineNotFoundException, StageNotFoundException, ActionNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApprovalResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putApprovalResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putApprovalResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutApprovalResult");
            PutApprovalResultResponse putApprovalResultResponse = (PutApprovalResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApprovalResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putApprovalResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutApprovalResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putApprovalResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putApprovalResult$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobFailureResultResponse putJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobFailureResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobFailureResult");
            PutJobFailureResultResponse putJobFailureResultResponse = (PutJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putJobFailureResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putJobFailureResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putJobFailureResult$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobSuccessResultResponse putJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, OutputVariablesSizeExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutJobSuccessResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobSuccessResult");
            PutJobSuccessResultResponse putJobSuccessResultResponse = (PutJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putJobSuccessResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putJobSuccessResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putJobSuccessResult$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobFailureResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobFailureResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobFailureResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobFailureResult");
            PutThirdPartyJobFailureResultResponse putThirdPartyJobFailureResultResponse = (PutThirdPartyJobFailureResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobFailureResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putThirdPartyJobFailureResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutThirdPartyJobFailureResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putThirdPartyJobFailureResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putThirdPartyJobFailureResult$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) throws ValidationException, JobNotFoundException, InvalidJobStateException, InvalidClientTokenException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutThirdPartyJobSuccessResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putThirdPartyJobSuccessResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putThirdPartyJobSuccessResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutThirdPartyJobSuccessResult");
            PutThirdPartyJobSuccessResultResponse putThirdPartyJobSuccessResultResponse = (PutThirdPartyJobSuccessResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutThirdPartyJobSuccessResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putThirdPartyJobSuccessResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutThirdPartyJobSuccessResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putThirdPartyJobSuccessResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putThirdPartyJobSuccessResult$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutWebhookResponse putWebhook(PutWebhookRequest putWebhookRequest) throws ValidationException, LimitExceededException, InvalidWebhookFilterPatternException, InvalidWebhookAuthenticationParametersException, PipelineNotFoundException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWebhookResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWebhookRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, putWebhookRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWebhook");
            PutWebhookResponse putWebhookResponse = (PutWebhookResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWebhook").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putWebhookRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutWebhookRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putWebhookResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$putWebhook$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterWebhookWithThirdPartyResponse registerWebhookWithThirdParty(RegisterWebhookWithThirdPartyRequest registerWebhookWithThirdPartyRequest) throws ValidationException, WebhookNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterWebhookWithThirdPartyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerWebhookWithThirdPartyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, registerWebhookWithThirdPartyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterWebhookWithThirdParty");
            RegisterWebhookWithThirdPartyResponse registerWebhookWithThirdPartyResponse = (RegisterWebhookWithThirdPartyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterWebhookWithThirdParty").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerWebhookWithThirdPartyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterWebhookWithThirdPartyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerWebhookWithThirdPartyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$registerWebhookWithThirdParty$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryStageExecutionResponse retryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, StageNotFoundException, StageNotRetryableException, NotLatestPipelineExecutionException, ConcurrentPipelineExecutionsLimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryStageExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retryStageExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, retryStageExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryStageExecution");
            RetryStageExecutionResponse retryStageExecutionResponse = (RetryStageExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryStageExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retryStageExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetryStageExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retryStageExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$retryStageExecution$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RollbackStageResponse rollbackStage(RollbackStageRequest rollbackStageRequest) throws ValidationException, ConflictException, PipelineNotFoundException, PipelineExecutionNotFoundException, PipelineExecutionOutdatedException, StageNotFoundException, UnableToRollbackStageException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RollbackStageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rollbackStageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, rollbackStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RollbackStage");
            RollbackStageResponse rollbackStageResponse = (RollbackStageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RollbackStage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rollbackStageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RollbackStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rollbackStageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$rollbackStage$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipelineExecutionResponse startPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, ConcurrentPipelineExecutionsLimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, startPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipelineExecution");
            StartPipelineExecutionResponse startPipelineExecutionResponse = (StartPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$startPipelineExecution$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPipelineExecutionResponse stopPipelineExecution(StopPipelineExecutionRequest stopPipelineExecutionRequest) throws ValidationException, ConflictException, PipelineNotFoundException, PipelineExecutionNotStoppableException, DuplicatedStopRequestException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPipelineExecutionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, stopPipelineExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipelineExecution");
            StopPipelineExecutionResponse stopPipelineExecutionResponse = (StopPipelineExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipelineExecution").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPipelineExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPipelineExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPipelineExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$stopPipelineExecution$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, TooManyTagsException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$tagResource$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ResourceNotFoundException, InvalidArnException, InvalidTagsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$untagResource$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateActionTypeResponse updateActionType(UpdateActionTypeRequest updateActionTypeRequest) throws RequestFailedException, ValidationException, ActionTypeNotFoundException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateActionTypeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateActionTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, updateActionTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateActionType");
            UpdateActionTypeResponse updateActionTypeResponse = (UpdateActionTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateActionType").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateActionTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateActionTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateActionTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$updateActionType$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, InvalidStageDeclarationException, InvalidActionDeclarationException, InvalidBlockerDeclarationException, InvalidStructureException, LimitExceededException, AwsServiceException, SdkClientException, CodePipelineException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidWebhookAuthenticationParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookAuthenticationParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookAuthenticationParametersException::builder).build());
                }
                case "InvalidActionDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActionDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidActionDeclarationException::builder).build());
                }
                case "InvalidArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                }
                case "PipelineExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotFoundException::builder).build());
                }
                case "PipelineNameInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNameInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNameInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "InvalidJobException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ActionTypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionTypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionTypeNotFoundException::builder).build());
                }
                case "StageNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotFoundException::builder).build());
                }
                case "DuplicatedStopRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicatedStopRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicatedStopRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagsException::builder).build());
                }
                case "ActionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionNotFoundException::builder).build());
                }
                case "InvalidStageDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStageDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStageDeclarationException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "NotLatestPipelineExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotLatestPipelineExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotLatestPipelineExecutionException::builder).build());
                }
                case "RequestFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                }
                case "InvalidClientTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientTokenException::builder).build());
                }
                case "InvalidJobStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidJobStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidJobStateException::builder).build());
                }
                case "PipelineVersionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineVersionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineVersionNotFoundException::builder).build());
                }
                case "InvalidWebhookFilterPatternException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidWebhookFilterPatternException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidWebhookFilterPatternException::builder).build());
                }
                case "OutputVariablesSizeExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OutputVariablesSizeExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OutputVariablesSizeExceededException::builder).build());
                }
                case "WebhookNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("WebhookNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(WebhookNotFoundException::builder).build());
                }
                case "InvalidApprovalTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidApprovalTokenException::builder).build());
                }
                case "ApprovalAlreadyCompletedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalAlreadyCompletedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ApprovalAlreadyCompletedException::builder).build());
                }
                case "ConditionNotOverridableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionNotOverridableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionNotOverridableException::builder).build());
                }
                case "PipelineNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineNotFoundException::builder).build());
                }
                case "PipelineExecutionOutdatedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionOutdatedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionOutdatedException::builder).build());
                }
                case "StageNotRetryableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("StageNotRetryableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(StageNotRetryableException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ConcurrentPipelineExecutionsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentPipelineExecutionsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentPipelineExecutionsLimitExceededException::builder).build());
                }
                case "InvalidStructureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStructureException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStructureException::builder).build());
                }
                case "InvalidBlockerDeclarationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlockerDeclarationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidBlockerDeclarationException::builder).build());
                }
                case "UnableToRollbackStageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnableToRollbackStageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnableToRollbackStageException::builder).build());
                }
                case "ActionExecutionNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActionExecutionNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActionExecutionNotFoundException::builder).build());
                }
                case "InvalidNonceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNonceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNonceException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "PipelineExecutionNotStoppableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PipelineExecutionNotStoppableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PipelineExecutionNotStoppableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCodePipelineClient.resolveMetricPublishers(clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CodePipeline");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            UpdatePipelineResponse updatePipelineResponse = (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCodePipelineClient.lambda$updatePipeline$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "codepipeline";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CodePipelineServiceClientConfigurationBuilder serviceConfigBuilder = new CodePipelineServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodePipelineException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CodePipelineServiceClientConfiguration serviceClientConfiguration() {
        return new CodePipelineServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePipeline$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateActionType$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipelineExecution$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipelineExecution$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rollbackStage$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryStageExecution$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerWebhookWithThirdParty$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWebhook$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobSuccessResult$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putThirdPartyJobFailureResult$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobSuccessResult$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobFailureResult$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putApprovalResult$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putActionRevision$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForThirdPartyJobs$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pollForJobs$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$overrideStageCondition$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWebhooks$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleTypes$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuleExecutions$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineExecutions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDeployActionExecutionTargets$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionTypes$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listActionExecutions$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getThirdPartyJobDetails$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineState$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineExecution$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipeline$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobDetails$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActionType$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableStageTransition$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableStageTransition$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterWebhookWithThirdParty$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWebhook$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomActionType$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomActionType$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeThirdPartyJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acknowledgeJob$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

