/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.SourceRevisionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceRevisionOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceRevisionOverride> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(SourceRevisionOverride.getter(SourceRevisionOverride::actionName)).setter(SourceRevisionOverride.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> REVISION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionType").getter(SourceRevisionOverride.getter(SourceRevisionOverride::revisionTypeAsString)).setter(SourceRevisionOverride.setter(Builder::revisionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionType").build()}).build();
    private static final SdkField<String> REVISION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionValue").getter(SourceRevisionOverride.getter(SourceRevisionOverride::revisionValue)).setter(SourceRevisionOverride.setter(Builder::revisionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, REVISION_TYPE_FIELD, REVISION_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceRevisionOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final String revisionType;
    private final String revisionValue;

    private SourceRevisionOverride(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.revisionType = builder.revisionType;
        this.revisionValue = builder.revisionValue;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final SourceRevisionType revisionType() {
        return SourceRevisionType.fromValue(this.revisionType);
    }

    public final String revisionTypeAsString() {
        return this.revisionType;
    }

    public final String revisionValue() {
        return this.revisionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceRevisionOverride)) {
            return false;
        }
        SourceRevisionOverride other = (SourceRevisionOverride)obj;
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.revisionTypeAsString(), other.revisionTypeAsString()) && Objects.equals(this.revisionValue(), other.revisionValue());
    }

    public final String toString() {
        return ToString.builder((String)"SourceRevisionOverride").add("ActionName", (Object)this.actionName()).add("RevisionType", (Object)this.revisionTypeAsString()).add("RevisionValue", (Object)this.revisionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "revisionType": {
                return Optional.ofNullable(clazz.cast(this.revisionTypeAsString()));
            }
            case "revisionValue": {
                return Optional.ofNullable(clazz.cast(this.revisionValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("revisionType", REVISION_TYPE_FIELD);
        map.put("revisionValue", REVISION_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceRevisionOverride, T> g) {
        return obj -> g.apply((SourceRevisionOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private String revisionType;
        private String revisionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceRevisionOverride model) {
            this.actionName(model.actionName);
            this.revisionType(model.revisionType);
            this.revisionValue(model.revisionValue);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getRevisionType() {
            return this.revisionType;
        }

        public final void setRevisionType(String revisionType) {
            this.revisionType = revisionType;
        }

        @Override
        public final Builder revisionType(String revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        @Override
        public final Builder revisionType(SourceRevisionType revisionType) {
            this.revisionType(revisionType == null ? null : revisionType.toString());
            return this;
        }

        public final String getRevisionValue() {
            return this.revisionValue;
        }

        public final void setRevisionValue(String revisionValue) {
            this.revisionValue = revisionValue;
        }

        @Override
        public final Builder revisionValue(String revisionValue) {
            this.revisionValue = revisionValue;
            return this;
        }

        public SourceRevisionOverride build() {
            return new SourceRevisionOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceRevisionOverride> {
        public Builder actionName(String var1);

        public Builder revisionType(String var1);

        public Builder revisionType(SourceRevisionType var1);

        public Builder revisionValue(String var1);
    }
}

