/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codestar.CodeStarClient;
import software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest;
import software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse;
import software.amazon.awssdk.services.codestar.model.CodeStarException;
import software.amazon.awssdk.services.codestar.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codestar.model.CreateProjectRequest;
import software.amazon.awssdk.services.codestar.model.CreateProjectResponse;
import software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.codestar.model.DeleteProjectRequest;
import software.amazon.awssdk.services.codestar.model.DeleteProjectResponse;
import software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.codestar.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.codestar.model.DescribeProjectRequest;
import software.amazon.awssdk.services.codestar.model.DescribeProjectResponse;
import software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest;
import software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberResponse;
import software.amazon.awssdk.services.codestar.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codestar.model.InvalidServiceRoleException;
import software.amazon.awssdk.services.codestar.model.LimitExceededException;
import software.amazon.awssdk.services.codestar.model.ListProjectsRequest;
import software.amazon.awssdk.services.codestar.model.ListProjectsResponse;
import software.amazon.awssdk.services.codestar.model.ListResourcesRequest;
import software.amazon.awssdk.services.codestar.model.ListResourcesResponse;
import software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest;
import software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse;
import software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest;
import software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse;
import software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.codestar.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.codestar.model.ProjectAlreadyExistsException;
import software.amazon.awssdk.services.codestar.model.ProjectConfigurationException;
import software.amazon.awssdk.services.codestar.model.ProjectCreationFailedException;
import software.amazon.awssdk.services.codestar.model.ProjectNotFoundException;
import software.amazon.awssdk.services.codestar.model.TagProjectRequest;
import software.amazon.awssdk.services.codestar.model.TagProjectResponse;
import software.amazon.awssdk.services.codestar.model.TeamMemberAlreadyAssociatedException;
import software.amazon.awssdk.services.codestar.model.TeamMemberNotFoundException;
import software.amazon.awssdk.services.codestar.model.UntagProjectRequest;
import software.amazon.awssdk.services.codestar.model.UntagProjectResponse;
import software.amazon.awssdk.services.codestar.model.UpdateProjectRequest;
import software.amazon.awssdk.services.codestar.model.UpdateProjectResponse;
import software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest;
import software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse;
import software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.codestar.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.codestar.model.UserProfileAlreadyExistsException;
import software.amazon.awssdk.services.codestar.model.UserProfileNotFoundException;
import software.amazon.awssdk.services.codestar.model.ValidationException;
import software.amazon.awssdk.services.codestar.transform.AssociateTeamMemberRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.CreateUserProfileRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.DeleteUserProfileRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.DescribeUserProfileRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.DisassociateTeamMemberRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.ListTagsForProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.ListTeamMembersRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.ListUserProfilesRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.TagProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.UntagProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.UpdateProjectRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.UpdateTeamMemberRequestMarshaller;
import software.amazon.awssdk.services.codestar.transform.UpdateUserProfileRequestMarshaller;

@SdkInternalApi
final class DefaultCodeStarClient
implements CodeStarClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeStarClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codestar";
    }

    @Override
    public AssociateTeamMemberResponse associateTeamMember(AssociateTeamMemberRequest associateTeamMemberRequest) throws LimitExceededException, ProjectNotFoundException, TeamMemberAlreadyAssociatedException, ValidationException, InvalidServiceRoleException, ProjectConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateTeamMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateTeamMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateTeamMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateTeamMemberRequest).withMarshaller((Marshaller)new AssociateTeamMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws ProjectAlreadyExistsException, LimitExceededException, ValidationException, ProjectCreationFailedException, InvalidServiceRoleException, ProjectConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createProjectRequest).withMarshaller((Marshaller)new CreateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateUserProfileResponse createUserProfile(CreateUserProfileRequest createUserProfileRequest) throws UserProfileAlreadyExistsException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateUserProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUserProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserProfileRequest).withMarshaller((Marshaller)new CreateUserProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws ConcurrentModificationException, ValidationException, InvalidServiceRoleException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteProjectRequest).withMarshaller((Marshaller)new DeleteProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserProfileResponse deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) throws ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUserProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserProfileRequest).withMarshaller((Marshaller)new DeleteUserProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest) throws ProjectNotFoundException, ValidationException, InvalidServiceRoleException, ProjectConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProjectRequest).withMarshaller((Marshaller)new DescribeProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserProfileResponse describeUserProfile(DescribeUserProfileRequest describeUserProfileRequest) throws UserProfileNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUserProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserProfileRequest).withMarshaller((Marshaller)new DescribeUserProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateTeamMemberResponse disassociateTeamMember(DisassociateTeamMemberRequest disassociateTeamMemberRequest) throws ProjectNotFoundException, ValidationException, InvalidServiceRoleException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateTeamMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateTeamMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateTeamMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateTeamMemberRequest).withMarshaller((Marshaller)new DisassociateTeamMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListProjectsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListProjectsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListProjects").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listProjectsRequest).withMarshaller((Marshaller)new ListProjectsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws ProjectNotFoundException, InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesRequest).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForProjectResponse listTagsForProject(ListTagsForProjectRequest listTagsForProjectRequest) throws ProjectNotFoundException, ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForProjectRequest).withMarshaller((Marshaller)new ListTagsForProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTeamMembersResponse listTeamMembers(ListTeamMembersRequest listTeamMembersRequest) throws ProjectNotFoundException, InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTeamMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTeamMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTeamMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTeamMembersRequest).withMarshaller((Marshaller)new ListTeamMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUserProfilesResponse listUserProfiles(ListUserProfilesRequest listUserProfilesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUserProfilesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUserProfilesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUserProfiles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUserProfilesRequest).withMarshaller((Marshaller)new ListUserProfilesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagProjectResponse tagProject(TagProjectRequest tagProjectRequest) throws ProjectNotFoundException, ValidationException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagProjectRequest).withMarshaller((Marshaller)new TagProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagProjectResponse untagProject(UntagProjectRequest untagProjectRequest) throws ProjectNotFoundException, ValidationException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagProjectRequest).withMarshaller((Marshaller)new UntagProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws ProjectNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateProjectResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateProjectResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateProject").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateProjectRequest).withMarshaller((Marshaller)new UpdateProjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateTeamMemberResponse updateTeamMember(UpdateTeamMemberRequest updateTeamMemberRequest) throws LimitExceededException, ProjectNotFoundException, ValidationException, InvalidServiceRoleException, ProjectConfigurationException, ConcurrentModificationException, TeamMemberNotFoundException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTeamMemberResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateTeamMemberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTeamMember").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTeamMemberRequest).withMarshaller((Marshaller)new UpdateTeamMemberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateUserProfileResponse updateUserProfile(UpdateUserProfileRequest updateUserProfileRequest) throws UserProfileNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodeStarException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserProfileResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateUserProfileResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUserProfile").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateUserProfileRequest).withMarshaller((Marshaller)new UpdateUserProfileRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeStarException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidServiceRoleException").exceptionBuilderSupplier(InvalidServiceRoleException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProjectAlreadyExistsException").exceptionBuilderSupplier(ProjectAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserProfileAlreadyExistsException").exceptionBuilderSupplier(UserProfileAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProjectConfigurationException").exceptionBuilderSupplier(ProjectConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProjectNotFoundException").exceptionBuilderSupplier(ProjectNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProjectCreationFailedException").exceptionBuilderSupplier(ProjectCreationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TeamMemberAlreadyAssociatedException").exceptionBuilderSupplier(TeamMemberAlreadyAssociatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UserProfileNotFoundException").exceptionBuilderSupplier(UserProfileNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TeamMemberNotFoundException").exceptionBuilderSupplier(TeamMemberNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

